//############################################################
// Form.h
// Kari Pulli
// 12/10/95
// A form class for a Motif GUI library
//############################################################

#ifndef _FORM_H_
#define _FORM_H_

extern "C" {
#include <Xm/Form.h>
}
#include "GraphicalObject.h"

class CString;

class Form : public GraphicalObject {
public:
  
  // kind of attachment
  enum Edge { TOP, BOTTOM, LEFT, RIGHT };

private:
  
  Widget findAttachWidget(const GraphicalObject &gobj) const;
    // finds immediate child of form given any ancestor of form

  void makeAttachment(Edge                   edge,
		      unsigned char          constraint,
		      int                    offset,
		      const GraphicalObject &gobj1,
		      const GraphicalObject *gobj2 = NULL);
    // sets appr. constraint resources of specified graphical
    // object for given edge and attachment type
public:
  
  enum { DefaultDivisions  = 100 };
  enum { DefaultHorizSpace = 0 };
  enum { DefaultVertSpace  = 0 };
  enum { DefaultOffset     = 0 };

  Form(const CString &        name,
       const GraphicalObject *parent = NULL,
       uint                   divisions = DefaultDivisions,
       uint                   hspace    = DefaultHorizSpace,
       uint                   vspace    = DefaultVertSpace);
  ~Form(void) {}

  void attachObjects(const GraphicalObject &gobj1,
		     const GraphicalObject &gobj2,
		     Edge                   edge,
		     int     offset = DefaultOffset);
    // attaches an edge of first object to the second

  void alignObjects(const GraphicalObject &gobj1,
		    const GraphicalObject &gobj2,
		    Edge                   edge,
		    int     offset = DefaultOffset);
    // aligns an edge of first object to the second
		   
  void attachForm(const GraphicalObject &gobj,
		  Edge                   edge,
		  int     offset = DefaultOffset);
    // attaches an edge of object to form

  void attachPosition(const GraphicalObject &gobj,
		      Edge                   edge,
		      int                    position);
    // attaches an edge of object to form, rel. posit.

};

#endif
