//############################################################
// GLDrawingArea.C
// Kari Pulli
// 11/03/96
// A class for a Motif GUI library
// mostly copied from E. Stollnitz's gizmo
//############################################################

#include "GLDrawingArea.h"
#include "CString.h"

#define SHOW(x) cout << #x " = " << x << endl;

/*** stub callbacks ***/
static void
ginit_cb(Widget, GLDrawingArea *gl_drawing_area,
	 GLwDrawingAreaCallbackStruct *call_data)
{
  XVisualInfo *vis;
  XtVaGetValues(Widget(*gl_drawing_area), 
		GLwNvisualInfo, &vis, NULL);
  GLXContext cx = glXCreateContext(getDisplay(),vis,NULL,GL_TRUE);
  if (!cx) {
    cerr << "GLDrawingArea::ginit: "
      << "Could not create GLX context." << endl;
    exit(1);
  }
  gl_drawing_area->setContext(cx);
  //gl_drawing_area->make_current();
  gl_drawing_area->push_context();
  gl_drawing_area->ginit(call_data);
  gl_drawing_area->pop_context();
}

static void
expose_cb(Widget, GLDrawingArea *gl_drawing_area,
	  GLwDrawingAreaCallbackStruct *call_data)
{
  if (call_data->event->xexpose.count == 0) {
    //gl_drawing_area->make_current();
    gl_drawing_area->push_context();
    gl_drawing_area->expose(call_data);
    gl_drawing_area->swapBuffers();
    gl_drawing_area->pop_context();
  }
}

static void
resize_cb(Widget, GLDrawingArea *gl_drawing_area,
	  GLwDrawingAreaCallbackStruct *call_data)
{
  //gl_drawing_area->make_current();
  gl_drawing_area->push_context();
  gl_drawing_area->resize(call_data);
  gl_drawing_area->pop_context();
}

static void
input_cb(Widget, GLDrawingArea *gl_drawing_area,
	 GLwDrawingAreaCallbackStruct *call_data)
{
  //gl_drawing_area->make_current();
  gl_drawing_area->push_context();
  gl_drawing_area->input(call_data);
  gl_drawing_area->pop_context();
}

void
GLDrawingArea::clear()
{
  //  make_current();
  push_context();
  // Figure out background color and clear window.
  Colormap cmap;
  XColor col;
  XtVaGetValues(rtr.mrep, XmNcolormap, &cmap, 
		XmNbackground, &col.pixel, NULL);
  XQueryColor(XtDisplay(rtr.mrep), cmap, &col);
  const float max_x_color = 255 << 8;  // maximum X Windows color
  glClearColor(col.red/max_x_color, col.green/max_x_color,
	       col.blue/max_x_color, 1);
  glClear(GL_COLOR_BUFFER_BIT);
  pop_context();
}

void
GLDrawingArea::redraw()
{
  if (XtIsRealized(rtr.mrep)) {
    //    make_current();
    push_context();
    expose(NULL);
    swapBuffers();
    pop_context();
  }
}

void
GLDrawingArea::swapBuffers()
{
  if (m_dblBuf) {
    //    make_current();
    push_context();
    GLwDrawingAreaSwapBuffers(rtr.mrep);
    pop_context();
  }
}

void
GLDrawingArea::ginit(GLwDrawingAreaCallbackStruct *)
{

}

void
GLDrawingArea::resize(GLwDrawingAreaCallbackStruct *call_data)
{  
  push_context();
  glViewport(0, 0, call_data->width, call_data->height);
  // Resize overlay window to match normal window.
  if (m_overlay_window)
    XResizeWindow(getDisplay(), m_overlay_window,
		  call_data->width, call_data->height);
  pop_context();
}

void
GLDrawingArea::expose(GLwDrawingAreaCallbackStruct *)
{

}

void
GLDrawingArea::input(GLwDrawingAreaCallbackStruct *)
{

}

GLDrawingArea::GLDrawingArea(const CString         &name,
			     const GraphicalObject *parent,
			     int                    useAlpha,
			     int                    useAcc,
			     int                    dblBuf)
: GraphicalObject(), m_dblBuf(dblBuf)
{
  Widget wparent = parent ? (Widget) *parent : topLevel;

  Arg args[20];
  int n = 0;
  XVisualInfo *vis;

  while (1) {
    int visattr[100];
    int i = 0;
    visattr[i++] = GLX_RGBA;
    if (m_dblBuf) visattr[i++] = GLX_DOUBLEBUFFER;
    visattr[i++] = GLX_RED_SIZE;
    visattr[i++] = 1;
    visattr[i++] = GLX_GREEN_SIZE;
    visattr[i++] = 1;
    visattr[i++] = GLX_BLUE_SIZE;
    visattr[i++] = 1;
    visattr[i++] = GLX_DEPTH_SIZE;
    visattr[i++] = 1;
    if (useAlpha) {
      visattr[i++] = GLX_ALPHA_SIZE;
      visattr[i++] = 1;
    }
    if (useAcc) {
      visattr[i++] = GLX_ACCUM_RED_SIZE;
      visattr[i++] = 1;
      visattr[i++] = GLX_ACCUM_GREEN_SIZE;
      visattr[i++] = 1;
      visattr[i++] = GLX_ACCUM_BLUE_SIZE;
      visattr[i++] = 1;
    }
    visattr[i++] = None;
  
    vis = glXChooseVisual(getDisplay(),
			  getScreenNumber(), 
			  visattr);
    if (vis) {
//      if (useAlpha)
//	cerr << "GLDrawingArea::create: Got alpha buffer." << endl;
      break;
    } else if (useAcc) {
      useAcc = 0;
      cerr << "GLDrawingArea::create: Couldn't get accumulation buffer." << endl;
    } else if (useAlpha) {
      useAlpha = 0;
      cerr << "GLDrawingArea::create: Couldn't get alpha buffer." << endl;
    } else {
      cerr << "GLDrawingArea::create: Failed to get the visual." << endl;
      rtr.mrep = NULL;
      return;
    }
  }
  XtSetArg(args[n], GLwNvisualInfo, vis);  n++;
  XtSetArg(args[n], GLwNallocateBackground, TRUE);  n++;
//  XtSetArg(args[n], XmNbackgroundPixmap, None);  n++;

  rtr.mrep = GLwCreateMDrawingArea(wparent, name, args, n);

  XtAddCallback(rtr.mrep, GLwNginitCallback,
		(XtCallbackProc) ginit_cb, (XtPointer) this);
  XtAddCallback(rtr.mrep, GLwNexposeCallback,
		(XtCallbackProc) expose_cb, (XtPointer) this);
  XtAddCallback(rtr.mrep, GLwNresizeCallback,
		(XtCallbackProc) resize_cb, (XtPointer) this);
  XtAddCallback(rtr.mrep, GLwNinputCallback,
		(XtCallbackProc) input_cb, (XtPointer) this);
}

void
GLDrawingArea::make_current()
{
  GLwDrawingAreaMakeCurrent(rtr.mrep, m_glx_context);
}

void
GLDrawingArea::push_context()
{
  //  pushed_context  = glXGetCurrentContext();
  //  pushed_drawable = glXGetCurrentDrawable();
//  pushed_display  = glXGetCurrentDisplayEXT();
  v_ctxt.push_back(glXGetCurrentContext());
  v_draw.push_back(glXGetCurrentDrawable());
  GLwDrawingAreaMakeCurrent(rtr.mrep, m_glx_context);
}

void
GLDrawingArea::pop_context()
{
  //  glXMakeCurrent(getDisplay(), pushed_drawable, 
  //		 pushed_context);
  glXMakeCurrent(getDisplay(), v_draw.back(), v_ctxt.back());
  v_ctxt.pop_back();
  v_draw.pop_back();
}


int
GLDrawingArea::create_overlay(int min_bits)
{
  // Make sure the normal window has been realized.
  if (!isRealized()) return 0;

  // Find overlay visual.
  static int attributeList[] = {GLX_LEVEL, 1,
				GLX_BUFFER_SIZE, min_bits,
				None};
  XVisualInfo *vi = glXChooseVisual(getDisplay(),
				    getScreenNumber(),
				    attributeList);
  if (!vi) {
    cerr << "Couldn't get visual for overlay" << endl;
    return 0;
  }

  // Create GLX context.
  m_overlay_context = glXCreateContext(getDisplay(), vi, NULL, 
				       GL_TRUE);

  // Create colormap and window.
  m_overlay_colormap = XCreateColormap(getDisplay(),
				       getRootWindow(),
				       vi->visual, AllocNone);
  XSetWindowAttributes wa;
  wa.colormap = m_overlay_colormap;
  wa.background_pixmap = None;
  wa.border_pixel = 0;
  Dimension width, height;
  XtVaGetValues(Widget(*this), 
		XmNwidth, &width,
		XmNheight, &height,
		NULL);
  m_overlay_window = XCreateWindow(getDisplay(), 
				   XtWindow(*this), 0, 0, 
				   width, height,
				   0, vi->depth, InputOutput, 
				   vi->visual,
				   CWBackPixmap | CWBorderPixel 
				   | CWColormap,
				   &wa);
  XMapWindow(getDisplay(), m_overlay_window);
  XSetWMColormapWindows(getDisplay(), XtWindow(shell()), 
			&m_overlay_window, 1);
  return TRUE;
}

void
GLDrawingArea::make_overlay_current() 
{
  glXMakeCurrent(getDisplay(), m_overlay_window, 
		 m_overlay_context);
}

int
GLDrawingArea::add_overlay_color3f(float r, float g, float b)
{
  XColor color;
  static const float max_x_color = 255 << 8; // maximum X Windows color
  color.red   = unsigned(r*max_x_color);
  color.green = unsigned(g*max_x_color);
  color.blue  = unsigned(b*max_x_color);
  if (XAllocColor(getDisplay(), m_overlay_colormap, &color))
    return int(color.pixel);
  else return -1;
}

int
GLDrawingArea::add_overlay_color3c(uchar r, uchar g, uchar b)
{
  XColor color;
  color.red   = r << 8;
  color.green = g << 8;
  color.blue  = b << 8;
  if (XAllocColor(getDisplay(), m_overlay_colormap, &color))
    return int(color.pixel);
  else return -1;
}
