//############################################################
// GLDrawingArea.h
// Kari Pulli
// 11/03/96
// A class for a Motif GUI library
//############################################################

#ifndef _GLDRAWINGAREA_H_
#define _GLDRAWINGAREA_H_

//extern "C" {
#include <Xm/MessageB.h>
#include <Xm/DrawingA.h>
#include <GL/GLwMDrawA.h>
//};
#include "GraphicalObject.h"
#include "vector.h"

class CString;

typedef unsigned char uchar;

class GLDrawingArea : public GraphicalObject {
public:
  GLDrawingArea(const CString         &name,
		const GraphicalObject *parent = NULL,
		int                    useAlpha = 0,
		int                    useAcc = 0,
		int                    dblBuf = 1);

  // need functions for adding callbacks
  void clear();
  void redraw();
  void swapBuffers();

  virtual void ginit(GLwDrawingAreaCallbackStruct *call_data);
  virtual void resize(GLwDrawingAreaCallbackStruct *call_data);
  virtual void expose(GLwDrawingAreaCallbackStruct *call_data);
  virtual void input(GLwDrawingAreaCallbackStruct *call_data);

  void setContext(GLXContext c) { m_glx_context = c; }
  void make_current(void);
  
  void push_context(void);
    // like make_current but stores the previous context
  void pop_context(void);
    // return to previous context

  int  create_overlay(int min_bits_per_pixel = 0);
  void make_overlay_current(void);
  int  add_overlay_color3f(float r, float g, float b); // [0.0,1.0]
  int  add_overlay_color3c(uchar r, uchar g, uchar b); // [0,255]

protected:
  GLXContext m_glx_context;

  Window     m_overlay_window;
  GLXContext m_overlay_context;
  Colormap   m_overlay_colormap;

  //  GLXContext  pushed_context;
  //  GLXDrawable pushed_drawable;
  vector<GLXContext>  v_ctxt;
  vector<GLXDrawable> v_draw;
  //  Display    *pushed_display;

  int         m_dblBuf;
};

#endif
