//############################################################
// GraphicalEnv.C
// Kari Pulli
// 12/08/95
// The base class for a Motif GUI library
//############################################################

#include <iostream.h>
#include <stdlib.h>
#include "GraphicalEnv.h"

const CString GraphicalEnv::appClass   = "LibraryApp";
//const CString GraphicalEnv::appClass   = "Inventor";
CString       GraphicalEnv::appName    = "";
XtAppContext  GraphicalEnv::appContext = (XtAppContext) NULL;
Window        GraphicalEnv::root       = (Window) NULL;
Display *     GraphicalEnv::display    = NULL;
int           GraphicalEnv::screen     = 0;
uint          GraphicalEnv::scrWidth   = 0;
uint          GraphicalEnv::scrHeight  = 0;
int           GraphicalEnv::depth      = 0;
Boolean       GraphicalEnv::debug      = FALSE;
int *         GraphicalEnv::argc       = NULL;
char **       GraphicalEnv::argv       = NULL;
Boolean       GraphicalEnv::classInit  = FALSE;

extern Boolean parseAppArguments (int argc, char **argv);
extern void    fatalErrorHandler (char *errstr);
extern void    errorHandler      (char *wrnstr);
extern int     errorHandlerX     (Display *, XErrorEvent *);
extern int     ioErrorHandlerX   (Display *);

void
GraphicalEnv::classConstruct(void)
{
  XtToolkitInitialize();
 
  appContext = XtCreateApplicationContext();

  // SGI specific color scheme
  String   defaults[]      = {"*sgiMode: True",
			      "*useSchemes: All",
			      NULL};
  XtAppSetFallbackResources(appContext, defaults);

  display = XtOpenDisplay(appContext,
			  NULL,
			  appName,
			  appClass,
			  NULL,
			  0,
			  argc,
			  argv);

  if (display == NULL) {
    cerr << "Failed to open display, exiting." << endl;
    exit(1);
  }
    
//  parseAppArguments(*argc, argv);

  XSynchronize(display, debug);

/*
  // set up error handlers
  XSetErrorHandler       (errorHandlerX);
  XSetIOErrorHandler     (ioErrorHandlerX);
  XtAppSetErrorHandler   (appContext, fatalErrorHandler);
  XtAppSetWarningHandler (appContext, errorHandler);
*/

  // other initialization
  screen    = DefaultScreen (display);
  root      = RootWindow    (display, screen);
  depth     = DefaultDepth  (display, screen);
  scrHeight = DisplayHeight (display, screen);
  scrWidth  = DisplayWidth  (display, screen);

  classInit = TRUE;
}


void
GraphicalEnv::setEnvironment(const CString &pname,
			     int           &ac,
			     char         **av,
			     Boolean        dflag)
{
  appName = pname;
  argc    = &ac;
  argv    = av;
  debug   = dflag;
}


void
GraphicalEnv::processEvent(void)
{
  XSync(display, FALSE); // get all the events currently in the queue
  XtAppProcessEvent(appContext, XtIMAll); // process an event
}
