//############################################################
// GraphicalEnv.h
// Kari Pulli
// 12/08/95
// The base class for a Motif GUI library
//############################################################

#ifndef _GRAPHICALENV_H_
#define _GRAPHICALENV_H_

extern "C" {
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
}
#include <iostream.h>
#include "Boolean.h"
#include "CString.h"

class GraphicalEnv {
protected:
  
  static const CString  appClass;
  static CString        appName;
  static XtAppContext   appContext;
  static Display       *display;    // the X display
  static Window         root;       // desktop X window
  static int            screen;     // X screen #
  static uint           scrWidth;   // X screen width
  static uint           scrHeight;  // X screen height
  static int            depth;      // # of color planes
  static Boolean        debug;      // debug graphics?
  static int           *argc;
  static char         **argv;
  static Boolean        classInit;  // class initialized?

  static void classConstruct(void);

  static void testConstruct(void)
    { if (!classInit) classConstruct(); }

  GraphicalEnv(void)
    { testConstruct(); }

public:

  ~GraphicalEnv(void) {}            

  static void setEnvironment(const CString &pname,
			     int           &ac,
			     char         **av,
			     Boolean        dflag = FALSE);
    // call this in the beginning of the program

  static const CString &getProgramName(void);

  static void processEvent(void);
    // processes the first event in queue for application

  static void startApp(void);
    // start the main app event loop

  // some access functions
  friend Display *getDisplay(void)       { return GraphicalEnv::display; }
  friend Window   getRootWindow(void)    { return GraphicalEnv::root; }
  friend int      getDepth(void)         { return GraphicalEnv::depth; }
  friend int      getScreenNumber(void)  { return GraphicalEnv::screen; }
  friend uint     screenWidth(void)   { return GraphicalEnv::scrWidth; }
  friend uint     screenHeight(void)  { return GraphicalEnv::scrHeight; }

};

inline const CString &
GraphicalEnv::getProgramName(void)
{ return appName; }

inline void 
GraphicalEnv::startApp(void)
{ XtAppMainLoop(appContext); }

#endif
