//############################################################
// InputDialog.C
// Kari Pulli
// 12/15/95
// A class for a Motif GUI library
//############################################################

#include "InputDialog.h"

InputDialog::InputDialog(CreateHook              cfn,
			 const CString          &name,
			 const GraphicalObject  *parent)
: Dialog(cfn, name, parent)
{
  XtAddCallback(rtr.mrep, XmNokCallback,     stateCB, this);
  XtAddCallback(rtr.mrep, XmNapplyCallback,  stateCB, this);
  XtAddCallback(rtr.mrep, XmNhelpCallback,   stateCB, this);
  XtAddCallback(rtr.mrep, XmNcancelCallback, stateCB, this);
}

void 
InputDialog::setPrompt(const CString &prompt)
{
  XmString mprompt =
    XmStringCreateSimple((char *) prompt);
  XtVaSetValues(rtr.mrep,
		XmNselectionLabelString, mprompt,
		NULL);
  XmStringFree(mprompt);
}

