//############################################################
// LEvent.C
// Kari Pulli
// 12/09/95
// The event class for a Motif GUI library
//############################################################

#include "LEvent.h"

uint LEvent::state(void) const
{
  switch (event->xany.type) {
  case KeyPress:
    return event->xkey.state;
  case ButtonPress:
  case ButtonRelease:
    return event->xbutton.state;
  case MotionNotify:
    return event->xmotion.state;
  default:
    return 0;
  }
}

LEvent::Kind
LEvent::kind(void) const
{
  if (event == NULL) return UnknownEvent;

  switch (event->xany.type) {
  case KeyPress:
    return KeyPressEvent;
  case ButtonPress:
    return ButtonPressEvent;
  case ButtonRelease:
    return ButtonReleaseEvent;
  case MotionNotify:
    return MotionEvent;
  case EnterNotify:
    return EnterEvent;
  case LeaveNotify:
    return LeaveEvent;
  default:
    return UnknownEvent;
  }
}

extern "C" {
#include <string.h>
#include <X11/keysym.h>
}

int 
LEvent::key(void) const
{
  static const int BufSize = 20;

  char buffer[BufSize+1];
  KeySym keysym;

  int count = XLookupString((XKeyEvent *) event,
			    buffer,
			    BufSize,
			    &keysym,
			    NULL);
  buffer[count] = 0;

  if (strlen(buffer)>1) {
    switch (keysym) {
    case XK_Home:
      return LHomeKey;
    case XK_Left:
      return LLeftKey;
    case XK_Up:
      return LUpKey;
    default:
      return LUnknownKey;
    }
  }
  
  return (int) buffer[0]; // the ascii code
}
