//############################################################
// LEvent.h
// Kari Pulli
// 12/09/95
// The event class for a Motif GUI library
//############################################################

#ifndef _LEVENT_H_
#define _LEVENT_H_

#include "GraphicalEnv.h"

class LEvent : public GraphicalEnv {
public:
  
  enum Kind {
    UnknownEvent,
    KeyPressEvent,
    ButtonPressEvent,
    ButtonReleaseEvent,
    MotionEvent,
    EnterEvent,
    LeaveEvent,
    EventKinds
    };

  enum SpecialKey {
    LHomeKey = -100, LLeftKey,   LUpKey,
    LRightKey,       LDownKey,   LPriorKey,
    LNextKey,        LUnknownKey
    };

  const XEvent *event;

  uint state(void) const; // get the state field

public:
  LEvent(void)             : GraphicalEnv() { event = NULL; }
  LEvent(const XEvent &xe) : GraphicalEnv() { event = &xe; }
  LEvent(const LEvent &e)  : GraphicalEnv() { event = e.event; }
  ~LEvent(void) {}

  void set(const XEvent &xevent)
    { event = &xevent; }

  Kind kind(void) const; // what kind of event?

  uint button(void) const
    { return event->xbutton.button; }

  int key(void) const; // ASCII of the key, or a special key

  Boolean button1Pressed(void) const
    { return state() & Button1Mask; }
  Boolean button2Pressed(void) const
    { return state() & Button2Mask; }
  Boolean button3Pressed(void) const
    { return state() & Button3Mask; }
  Boolean controlPressed(void) const
    { return state() & ControlMask; }
  Boolean shiftPressed(void) const
    { return state() & ShiftMask; }
  Boolean lockPressed(void) const
    { return state() & LockMask; }

  int x(void) const { return event->xbutton.x; }
  int y(void) const { return event->xbutton.y; }
    // location, relative to event window

  int screenx(void) const { return event->xbutton.x_root; }
  int screeny(void) const { return event->xbutton.y_root; }
    // location, relative to screen
};

#endif

