//############################################################
// LTextField.C
// Kari Pulli
// 01/02/96
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/TextF.h>
#include <Xm/Form.h>
#include <Xm/Label.h>
}
#include "LTextField.h"
#include "CString.h"


LTextField::LTextField(const CString &        name,
		       const GraphicalObject *parent,
		       uint                   cwidth,
		       uint                   maxLen,
		       Boolean                stretch)
: Form(name, parent),
  Label(name+CString("_label"), (Form *)this),
  SVTextField(name+CString("_field"), (Form *)this, cwidth, maxLen)
{
  // don't treat this as a tab group
  XtVaSetValues(Form::rtr.mrep,
		XmNnavigationType, XmNONE,
		NULL);
  XtVaSetValues(SVTextField::rtr.mrep,
		XmNnavigationType, XmNONE,
		NULL);
  Label::manage();
  SVTextField::manage();

  attachForm(*((Label *) this),       Form::LEFT);
  attachForm(*((Label *) this),       Form::TOP);
  attachForm(*((SVTextField *) this), Form::BOTTOM);
  attachForm(*((SVTextField *) this), Form::LEFT);
  attachObjects(*((SVTextField *) this), 
		*((Label *) this),    Form::TOP, 0);

  if (stretch) {
    attachForm(*((Label *) this),       Form::RIGHT);
    attachForm(*((SVTextField *) this), Form::RIGHT);
  }
}
