//############################################################
// LTextField.h
// Kari Pulli
// 01/02/96
// A class for a Motif GUI library
//############################################################

#ifndef _LTEXTFIELD_H_
#define _LTEXTFIELD_H_

#include "Form.h"
#include "Label.h"
#include "SVTextField.h"

class CString;

#define GOBJ(g) *((GraphicalObject*)g)

class LTextField : private Form, public SVTextField, public Label {
public:

  LTextField(const CString &        name,
	     const GraphicalObject *parent  = NULL,
	     uint                   cwidth  = TextField::DefaultWidth,
	     uint                   maxLen  = TextField::Unlimited,
	     Boolean                stretch = FALSE);

  ~LTextField(void) {}

  // casts
  operator GraphicalObject *(void) const
    { return (Form *) this; }
  operator Widget(void) const
    { return Form::operator Widget(); }

  void operator =(const CString &s)
    { *((TextField *)this) = s; }
  
  void manage(void) const
    { Form::manage(); }
  void unmanage(void) const
    { Form::unmanage(); }
  void realize(void) const
    { Form::realize(); }
  void unrealize(void) const
    { Form::unrealize(); }
  Boolean isRealized(void) const
    { return Form::isRealized(); }
};

#endif
