//############################################################
// Label.C
// Kari Pulli
// 12/13/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/Label.h>
}
#include "Label.h"

Label::Label(const CString &        name,
	     const GraphicalObject *parent)
: GraphicalObject()
{
  rtr.mrep = XmCreateLabel(parent ? (Widget) *parent : topLevel,
			   (char *) name,
			   NULL, 0);
}
void 
Label::changeText(const CString &text)
{
  XmString mtext = XmStringCreateSimple((char *)text);
  XtVaSetValues(rtr.mrep, XmNlabelString, mtext, NULL);
  XmStringFree(mtext);
}

static unsigned char AlignLookUp[] = {
  XmALIGNMENT_BEGINNING,
  XmALIGNMENT_CENTER,
  XmALIGNMENT_END
  };

void
Label::align(Alignment al)
{
  XtVaSetValues(rtr.mrep, 
		XmNalignment, AlignLookUp[al],
		NULL);
}
