//############################################################
// List.h
// Kari Pulli
// 12/09/95
//############################################################

template <class T> class List;

template <class T> class ListItem {
friend class List<T>;
private:
  ListItem<T> *next;
  const T      item;
  ListItem(const ListItem<T> *n, const T &i)
    : item(i), next((ListItem<T>*)n) {}
};

template <class T> class List {
public:
  void put(const T& t) { head = new ListItem<T>(head, t); }
  T get() { // get from the head of list
    T retval = head->item;
    ListItem<T> *temp = head;
    head = head->next;
    delete temp;
    return retval;
  }
  List() : head(0) {}
private:
  ListItem<T> *head;
};
