//############################################################
// MainWindow.C
// Kari Pulli
// 12/10/95
// A class for a Motif GUI library
//############################################################

#include "MainWindow.h"
#include "ControlPanel.h"
#include "MenuBar.h"
#include "CString.h"

MainWindow::MainWindow(const CString &name)
: Form(name)
{
  workSpace  = NULL;
  leftPanel  = NULL;
  bottPanel  = NULL;
  menuBar    = NULL;
}

void 
MainWindow::set(const GraphicalObject  &ws,
		const MenuBar          *mb,
		const ControlPanel     *leftP,
		const ControlPanel     *bottP)
{
  workSpace = &ws;
  menuBar   = mb;
  leftPanel = leftP;
  bottPanel = bottP;

  if (menuBar) {
    attachForm(*menuBar, Form::RIGHT);
    attachForm(*menuBar, Form::TOP);
    attachForm(*menuBar, Form::LEFT);
  }
  if (bottPanel) {
    attachForm(*bottPanel, Form::RIGHT);
    attachForm(*bottPanel, Form::BOTTOM);
    attachForm(*bottPanel, Form::LEFT);
  }

  if (workSpace) {
    attachForm(*workSpace, Form::RIGHT);
    if (menuBar)
      attachObjects(*workSpace, *menuBar, Form::TOP);
    else
      attachForm(*workSpace, Form::TOP);
    if (bottPanel)
      attachObjects(*workSpace, *bottPanel, Form::BOTTOM);
    else
      attachForm(*workSpace, Form::BOTTOM);
    if (leftPanel)
      attachObjects(*workSpace, *leftPanel, Form::LEFT);
    else
      attachForm(*workSpace, Form::LEFT);
  }

  if (leftPanel) {
    attachForm(*leftPanel, Form::LEFT);
    if (menuBar)
      attachObjects(*leftPanel, *menuBar, Form::TOP);
    else
      attachForm(*leftPanel, Form::TOP);
    if (bottPanel)
      attachObjects(*leftPanel, *bottPanel, Form::BOTTOM);
    else
      attachForm(*leftPanel, Form::BOTTOM);
  }
}
