//############################################################
// MainWindow.h
// Kari Pulli
// 12/10/95
// A class for a Motif GUI library
//############################################################

#ifndef _MAINWINDOW_H_
#define _MAINWINDOW_H_

#include "Form.h"

class MenuBar;
class ControlPanel;
class CString;

class MainWindow : public Form {
  
  const GraphicalObject  *workSpace;
  const MenuBar          *menuBar;
  const ControlPanel     *leftPanel;
  const ControlPanel     *bottPanel;

public:
  
  MainWindow(const CString &name);
  ~MainWindow(void) {}

  void set(const GraphicalObject  &ws,
	   const MenuBar          *mb    = NULL,
	   const ControlPanel     *leftP = NULL,
	   const ControlPanel     *bottP = NULL);

  const GraphicalObject * getWorkSpace    (void) const
    { return workSpace; }
  const MenuBar *         getMenuBar      (void) const
    { return menuBar; }
  const ControlPanel *    getLeftPanel (void) const
    { return leftPanel; }
  const ControlPanel *    getBottomPanel (void) const
    { return bottPanel; }
};

#endif
