//############################################################
// MenuBar.C
// Kari Pulli
// 12/11/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/RowColumn.h>
}

#include "CString.h"
#include "MainWindow.h"
#include "MenuBar.h"
#include "CascadeButton.h"

MenuBar::MenuBar(const CString    &name, 
		 const MainWindow &parent)
: GraphicalObject()
{
  rtr.mrep = XmCreateMenuBar((Widget) parent,
			     (char *) name,
			     NULL, 0);
}

void 
MenuBar::setHelpButton(const CascadeButton &hb)
{
  XtVaSetValues(rtr.mrep,
		XmNmenuHelpWidget, (Widget) hb,
		NULL);
}
