//############################################################
// OutputDialog.C
// Kari Pulli
// 12/19/95
// A class for a Motif GUI library
//############################################################

#include "OutputDialog.h"

OutputDialog::OutputDialog(CreateHook              cfn,
			   const CString          &name,
			   const GraphicalObject  *parent)
: Dialog(cfn, name, parent)
{
  XtAddCallback(rtr.mrep, XmNokCallback,     stateCB, this);
  XtAddCallback(rtr.mrep, XmNhelpCallback,   stateCB, this);
  XtAddCallback(rtr.mrep, XmNcancelCallback, stateCB, this);
  hideButton(HELP);
}

extern unsigned char ButtonLookup[]; // in PromptDialog.C

Widget 
OutputDialog::findButton(StandardButton b) const
{
  return XmMessageBoxGetChild(rtr.mrep, ButtonLookup[b]);
}

const CString &
OutputDialog::operator =(const CString &text)
{
  XmString mmessage = XmStringCreateSimple((char *) text);
  XtVaSetValues(rtr.mrep, XmNmessageString, mmessage, NULL);
  XmStringFree(mmessage);
  return text;
}
