//############################################################
// PictureButton.C
// Kari Pulli
// 12/11/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/DrawnB.h>
}
#include <assert.h>
#include "ControlPanel.h"
#include "CString.h"
#include "PixelMap.h"
#include "PictureButton.h"

#include <iostream.h>
#define SHOW(x) cout << #x << " = " << x << endl;

PictureButton::PictureButton(const CString       &name,
			     const ControlPanel  &parent,
			     PixelMap            *pm,
			     PixelMap            *ipm)
{
  assert(pm);

  Arg args[4];

  XtSetArg(args[0], XmNshadowThickness, 3);
  XtSetArg(args[1], XmNmultiClick, XmMULTICLICK_DISCARD);
  XtSetArg(args[2], XmNpushButtonEnabled, True);
  XtSetArg(args[3], XmNshadowType, XmSHADOW_ETCHED_OUT);

  rtr.mrep = XmCreateDrawnButton((Widget) parent,
				 (char *) name,
				 args, 4);

  // set the pixel maps
  sensPm   = pm;
  insensPm = ipm;

  // resize and exposure callbacks
  XtAddCallback(rtr.mrep,
		XmNresizeCallback,
		drawButtonCB,
		this);
  XtAddCallback(rtr.mrep,
		XmNexposeCallback,
		drawButtonCB,
		this);
  manage();
}

void
drawButtonCB(Widget     w,
	     XtPointer  clientd,
	     XtPointer  )
{
  if (XtIsRealized(w) == False) return;

  PictureButton *button = (PictureButton *) clientd;
  assert(button->sensPm);

  Dimension highlight, shadow, bdrw, // widths
            winw, winh;              // dims
  Bool      sens;

  XtVaGetValues(w,
		XmNwidth,               &winw,
		XmNheight,              &winh,
		XmNborderWidth,         &bdrw,
		XmNhighlightThickness,  &highlight,
		XmNshadowThickness,     &shadow,
		XmNsensitive,           &sens,
		NULL);

  PixelMap *pm = sens || button->insensPm == NULL ?
    button->sensPm : button->insensPm;

  int pmw, pmh;  // pixel map dims
  pmw = pm->getWidth();
  pmh = pm->getHeight();

  int border;       // # pixel in button border
  int dimNoBorders; // width/height of button face w/o borders
  border = bdrw + highlight + shadow;
  dimNoBorders = winw - (2*border);

  int srcx, srcy, destx, desty; // copy: pixelmap origin, button face dest

  // center horizontally
  if (dimNoBorders > pmw) {
    srcx  = 0;
    destx = (dimNoBorders - pmw)/2 + border;
  } else {
    srcx  = (pmw - dimNoBorders)/2;
    destx = border;
    pmw   = dimNoBorders;
  }
  // now vertically
  dimNoBorders = winh - (2*border);
  if (dimNoBorders > pmh) {
    srcy  = 0;
    desty = (dimNoBorders - pmh)/2 + border;
  } else {
    srcy  = (pmh - dimNoBorders)/2;
    desty = border;
    pmh   = dimNoBorders;
  }

  GC gc = XtGetGC(w, 0L, NULL);

  XCopyArea(getDisplay(),
	    (Pixmap) *pm,
	    XtWindow(w),
	    gc,
	    srcx, srcy,
	    pmw, pmh,
	    destx, desty);
  XtReleaseGC(w, gc);
}
