//############################################################
// PixelMap.h
// Kari Pulli
// 12/09/95
// The pixelmap class for a Motif GUI library
//############################################################

#ifndef _PIXELMAP_H_
#define _PIXELMAP_H_

#include "GraphicalEnv.h"

class PixelMap : public GraphicalEnv
{
  uint    width;
  uint    height;
  Pixmap  pixmap;  // X representation

  void zero(void)
    { width = height = 0; pixmap = (Pixmap) NULL; }

public:

  PixelMap(void) : GraphicalEnv() { zero(); }
  PixelMap(uint w, uint h) : GraphicalEnv()
    { zero(); resize(w,h); }
  PixelMap(const PixelMap &other);
  ~PixelMap(void);

  Boolean read(const CString &fileName);

  Boolean resize(uint w, uint h); 
    // resizes and destroys pixel map contents

  void clear(const CString &colName);

  uint getWidth(void)  const { return width; }
  uint getHeight(void) const { return height; }

  operator Pixmap(void) const { return pixmap; }
};

#endif
