//############################################################
// PromptDialog.C
// Kari Pulli
// 12/18/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/SelectioB.h>
};
#include "PromptDialog.h"

PromptDialog::PromptDialog(const CString         &name,
			   const GraphicalObject *parent,
			   const CString         &prompt,
			   const CString         &text)
: InputDialog(XmCreatePromptDialog, name, parent)
{
  hideButton(HELP);
  setPrompt(prompt);
  PromptDialog::operator =(text);
}

unsigned char ButtonLookup[] = {
  XmDIALOG_OK_BUTTON,
  XmDIALOG_APPLY_BUTTON,
  XmDIALOG_CANCEL_BUTTON,
  XmDIALOG_HELP_BUTTON,
};

Widget 
PromptDialog::findButton(StandardButton b) const
{
  return XmSelectionBoxGetChild(rtr.mrep, ButtonLookup[b]);
}

PromptDialog::operator CString(void) const
{
  XmString mtext;
  XtVaGetValues(rtr.mrep, XmNtextString, &mtext, NULL);

  char    *ctext;
  XmStringGetLtoR(mtext, XmSTRING_DEFAULT_CHARSET, &ctext);

  CString text(ctext);

  XtFree(ctext);
  XmStringFree(mtext);

  return text;
}

const CString &
PromptDialog::operator =(const CString &text)
{
  XmString mtext = XmStringCreateSimple((char *) text);
  XtVaSetValues(rtr.mrep, XmNtextString, mtext, NULL);
  XmStringFree(mtext);
  return text;
}
