//############################################################
// PulldownMenu.C
// Kari Pulli
// 12/11/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/RowColumn.h>
}
#include "CString.h"
#include "MenuBar.h"
#include "PulldownMenu.h"
#include "OptionMenu.h"
#include "Separator.h"

PulldownMenu::PulldownMenu(const CString &name, 
			   const MenuBar &parent)
{
  rtr.mrep = XmCreatePulldownMenu((Widget) parent,
				  (char *) name,
				  NULL, 0);
}

PulldownMenu::PulldownMenu(const CString &name, 
			   const PulldownMenu &parent)
{
  rtr.mrep = XmCreatePulldownMenu((Widget) parent,
				  (char *) name,
				  NULL, 0);
}

PulldownMenu::PulldownMenu(const CString &name, 
			   const OptionMenu &parent)
{
  rtr.mrep = XmCreatePulldownMenu((Widget) parent,
				  (char *) name,
				  NULL, 0);
}

void
PulldownMenu::addSeparator(void)
{
  CString name("sep_");
  name += ntos((long)sepList.GetCount());
  Separator *sep = new Separator(name, this);
  sepList.Append(sep);
  sep->manage();
}

PulldownMenu::~PulldownMenu(void)
{
  if (sepList.GetCount()) {
    sepList.ToHead();
    do {
      delete sepList.Get();
    } while (sepList.ToNext());
  }
  sepList.Erase();
}
