//############################################################
// RadioBox.C
// Kari Pulli
// 12/20/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/ToggleB.h>
#include <Xm/RowColumn.h>
#include <limits.h>
}
#include "RadioBox.h"

const uint RadioBox::NONE_SELECTED = UINT_MAX;

RadioBox::RadioBox(const CString &        name,
		   const GraphicalObject *parent,
		   Behavior               bv,
		   uint                   columns)
: GraphicalObject()
{
  userCB = NULL;
  udata  = NULL;

  Widget wparent = parent ? (Widget) *parent : topLevel;

  short numCols = columns ? (short) columns : 1;

  rtr.mrep = 
    XtVaCreateWidget(name,
		     xmRowColumnWidgetClass,
		     wparent,
		     XmNpacking, XmPACK_COLUMN,
		     XmNentryClass, xmToggleButtonWidgetClass,
		     XmNnumColumns, numCols,
		     XmNradioBehavior, bv != MANY,
		     XmNradioAlwaysOne, bv== ALWAYS_ONE,
		     NULL);

}

RadioBox::~RadioBox(void)
{
  for (int i=0; i<toggles.count; i++)
    XtDestroyWidget(toggles[i]);
}

void 
RadioBox::setToggleCallback(ToggleCallback cb,
			    void *data)
{
  userCB = cb;
  udata  = data;
}

void 
RadioBox::addToggle(const CString &toggleName)
{
  Widget togb = XtVaCreateManagedWidget((char *)toggleName,
					xmToggleButtonWidgetClass,
					rtr.mrep, NULL);
  toggles += togb;

  XtAddCallback(togb,
		XmNvalueChangedCallback,
		toggleCB,
		this);
}

uint 
RadioBox::togglePos(const CString &name) const
{
  for (uint i=0; i<toggles.count; i++) {
    if (name == CString(XtName(toggles[i])))
      return i;
  }
  return NONE_SELECTED;
}

CString 
RadioBox::toggleName(uint pos) const
{
  CString name;
  if (toggles.count > 0 && pos < toggles.count)
    name = XtName(toggles[pos]);
  return name;
}

Boolean 
RadioBox::changeToggle(uint    pos,
		       Boolean state,
		       Boolean invoke)
{
  if (toggles.count > 0 && pos < toggles.count) {
    XmToggleButtonSetState(toggles[pos],
			   (Bool) state,
			   (Bool) invoke);
    return TRUE;
  }
  return FALSE;  
}

void 
RadioBox::setAllToggles   (Boolean invoke)
{
  for (int i=0; i<toggles.count; i++)
    XmToggleButtonSetState(toggles[i],
			   True,
			   (Bool) invoke);
}

void 
RadioBox::clearAllToggles (Boolean invoke)
{
  for (int i=0; i<toggles.count; i++)
    XmToggleButtonSetState(toggles[i],
			   False,
			   (Bool) invoke);
}

Boolean 
RadioBox::isSet(uint pos) const
{
  Boolean set = FALSE;
  if (toggles.count > 0 && pos < toggles.count) {
    set = XmToggleButtonGetState(toggles[pos]);
  }
  return set;
}

uint 
RadioBox::getSelected(void) const
{
  for (int i=0; i<toggles.count; i++)
    if (XmToggleButtonGetState(toggles[i])) 
      return i;
  return NONE_SELECTED;
}


void
toggleCB(Widget w, XtPointer clientd, XtPointer )
{
  RadioBox *radioBox = (RadioBox *) clientd;

  if (radioBox->userCB) {
    radioBox->userCB(*radioBox,
		     radioBox->togglePos(XtName(w)),
		     radioBox->udata);
  }
}
