//############################################################
// RadioBox.h
// Kari Pulli
// 12/20/95
// A class for a Motif GUI library
//############################################################

#ifndef _RADIOBOX_H_
#define _RADIOBOX_H_

#include "GraphicalObject.h"
#include "CString.h"


class RadioBox : public GraphicalObject {
public:

  enum Behavior {
    ONE_OR_NONE,
    ALWAYS_ONE,
    MANY,
  };

  static const uint NONE_SELECTED;

  typedef void (* ToggleCallback)(RadioBox  &radioBox,
				  uint       pos,
				  void      *udata);

private:
  class WList {
    Widget *w;
    uint    size;
  public:
    uint    count;
    WList(void) : count(0), size(10) { w = new Widget[10]; }
    WList &operator +=(Widget _w)
      { 
	if (count==size) {
	  Widget *tmp = new Widget[size+10];
	  for (int i=0; i<size; i++) tmp[i] = w[i];
	  delete[] w; w = tmp;
	  size+=10;
	}
	w[count++] = _w;
	return *this;
      }
    Widget &operator [](int i) const { return w[i]; }
    ~WList(void)                     { delete[] w; }
  };

  Behavior       behavior; 
  WList          toggles;
  ToggleCallback userCB;
  void *         udata;

  friend void toggleCB(Widget w, XtPointer clientd, XtPointer calld);

public:

  RadioBox(const CString &        name,
	   const GraphicalObject *parent   = NULL,
	   Behavior               bv       = MANY,
	   uint                   columns  = 0);

  ~RadioBox(void);

  void setToggleCallback(ToggleCallback cb,
			 void *udata = NULL);

  void addToggle(const CString &toggleName);

  uint togglePos(const CString &tname) const;
  CString toggleName(uint pos) const;

  uint toggleCount(void) const
    { return toggles.count; }

  Boolean changeToggle(uint    pos,
		       Boolean val,
		       Boolean invoke = FALSE);
    // change the state of toggle, possibly invoke callback
  void setAllToggles   (Boolean invoke = FALSE);
  void clearAllToggles (Boolean invoke = FALSE);

  Boolean isSet(uint pos) const;

  uint getSelected(void) const;
    // position of the first selected toggle
};

#endif
