//############################################################
// SVTextField.C
// Kari Pulli
// 01/02/96
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/TextF.h>
}
#include "SVTextField.h"
#include "CString.h"


SVTextField::SVTextField(const CString &        name,
			 const GraphicalObject *parent,
			 uint                   cwidth,
			 uint                   maxLen)
: TextField(name, parent, cwidth, maxLen)
{
  cb    = NULL;
  udata = NULL;
  XtAddCallback(rtr.mrep,
		XmNmodifyVerifyCallback,
		validateCB, this);
}


void 
validateCB(Widget    ,
	   XtPointer calld,
	   XtPointer clientd)
{
  SVTextField *field = (SVTextField *) calld;
  XmTextVerifyCallbackStruct *cbs = 
    (XmTextVerifyCallbackStruct *) clientd;
  if (!field->cb) {
    cbs->doit = True;
    return;
  }

  CString text;
  int     i;
  // string in callback data is NOT null-terminated,
  // so copy char by char
  if (cbs->text->ptr) {
    for (i=0; i<cbs->text->length; i++)
      text += (CString) cbs->text->ptr[i];
  }
  // invoke user callback
  cbs->doit = field->cb(*field,
			text,
			(uint) cbs->currInsert,
			(uint) cbs->startPos,
			(uint) cbs->endPos,
			field->udata);
  // reassign modification string to callback struct
  // because user callback may have changed it
  if (cbs->doit) {
    // free existing text
    XtFree(cbs->text->ptr);
    // set new length
    cbs->text->length = (int) text.length();
    // set new text
    if (text.length() == 0) cbs->text->ptr = NULL;
    else {
      cbs->text->ptr = XtMalloc(text.length());
      for (i=0; i<(int) text.length(); i++)
	cbs->text->ptr[i] = text[i];
    }
  }
}
