//############################################################
// SVTextField.h
// Kari Pulli
// 01/02/96
// A class for a Motif GUI library
//############################################################

#ifndef _SVTEXTFIELD_H_
#define _SVTEXTFIELD_H_

#include "TextField.h"

class CString;


class SVTextField : public TextField {
public:

  // user validation callback handler prototype
  typedef Boolean (* ValidateCallback)(SVTextField &field,
				       CString     &text,
				       uint         currIns,
				       uint         startPos,
				       uint         endPos,
				       void        *udata);
protected:
  
  ValidateCallback cb;
  void            *udata;

  friend void validateCB(Widget    w,
			 XtPointer textField,
			 XtPointer cbs);
public:

  SVTextField(const CString &        name,
	      const GraphicalObject *parent = NULL,
	      uint                   cwidth = DefaultWidth,
	      uint                   maxLen = Unlimited);

  ~SVTextField(void) {}

  void setValidateCallback(ValidateCallback ucb,
			   void *data = NULL)
    { cb = ucb; udata = data; }
};

#endif
