//############################################################
// Scale.C
// Kari Pulli
// 12/21/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/Scale.h>
#include <math.h>
}
#include "Scale.h"
#include "CString.h"

Scale::Scale(const CString         &name,
	     const GraphicalObject *parent,
	     Boolean                sensitive,
	     Orientation            orient)
{
  Widget wparent = parent ? (Widget) *parent : topLevel;

  Arg      argv[4];
  Cardinal argc = 0;

  XtSetArg(argv[argc], XmNshowValue,   True); argc++;
  XtSetArg(argv[argc], XmNsensitive,   (Bool) sensitive); argc++;
  XtSetArg(argv[argc], XmNvalue,       0); argc++;
  XtSetArg(argv[argc], XmNorientation, orient == HORIZONTAL ?
	   XmHORIZONTAL : XmVERTICAL); argc++;
  rtr.mrep = XmCreateScale(wparent, (char *) name, argv, argc);
}

inline int
shiftLeft(double v, int places)
{
  return v * pow(10,places);
}

void 
Scale::setBounds(double maxVal,
		 double minVal,
		 short  decPts)
{
  int smin = (int) shiftLeft(minVal, decPts);
  int smax = (int) shiftLeft(maxVal, decPts);
  int sval = (smin+smax)/2;
  XtVaSetValues(rtr.mrep,
		XmNminimum,        smin,
		XmNmaximum,        smax,
		XmNvalue,          sval,
		XmNdecimalPoints,  decPts,
		NULL);
}

inline double
shiftRight(int v, short places)
{
  return double(v) / pow(10,places);
}

Scale::operator double(void) const
{
  int   value;
  short decPts;

  XtVaGetValues(rtr.mrep,
		XmNvalue,         &value,
		XmNdecimalPoints, &decPts,
		NULL);
  return shiftRight(value, decPts);
}

double 
Scale::operator =(double d)
{
  short decPts;
  XtVaGetValues(rtr.mrep,
		XmNdecimalPoints, &decPts,
		NULL);
  int value = shiftLeft(d, decPts);
  XtVaSetValues(rtr.mrep, XmNvalue, value, NULL);
  return d;
}

void 
Scale::setLabel(const CString &label)
{
  XmString mlabel = XmStringCreateSimple((char *) label);
  XtVaSetValues(rtr.mrep, XmNtitleString, mlabel, NULL);
  XmStringFree(mlabel);
}
