//############################################################
// TextButton.C
// Kari Pulli
// 12/11/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/PushB.h>
}
#include "TextButton.h"
#include "PulldownMenu.h"
#include "CString.h"

TextButton::TextButton(const CString         &label,
		       const GraphicalObject *parent)
: Button()
{
  Widget wparent = parent ? (Widget) *parent : topLevel;

  rtr.mrep = XmCreatePushButton(wparent,
				(char *) label,
				NULL, 0);
  manage();
}

#include "Color.h"

void 
TextButton::setColor(const CString &colName)
{
  Color col(colName);
  XtVaSetValues(rtr.mrep, XmNforeground, (ulong) col, NULL);
}

void
TextButton::setLabel(const CString &label)
{
  XmString mtext = XmStringCreateSimple((char *) label);
  XtVaSetValues(rtr.mrep, XmNlabelString, mtext, NULL);
  XmStringFree(mtext);
}

void 
TextButton::setAccelerator(const CString &acc, 
			   const CString &acc_text)
{
  XmString text = XmStringCreateSimple((char *) acc_text);
  XtVaSetValues(rtr.mrep,
		XmNaccelerator,     (char *) acc,
		XmNacceleratorText, text,
		NULL);
  XmStringFree(text);
}
