//############################################################
// TextField.C
// Kari Pulli
// 12/13/95
// A class for a Motif GUI library
//############################################################

extern "C" {
#include <Xm/TextF.h>
}

#include "TextField.h"
  
const uint TextField::DefaultWidth = 0;
const uint TextField::Unlimited    = 0;

TextField::TextField(const CString         &name,
		     const GraphicalObject *parent,
		     uint                   cwidth,
		     uint                   maxLen)
: GraphicalObject()
{
  Widget wparent = parent ? (Widget) *parent : topLevel;

  Arg      argv[10];
  Cardinal argc = 0;
  
  if (cwidth)
    XtSetArg(argv[argc], XmNcolumns, cwidth), argc++;
  if (maxLen)
    XtSetArg(argv[argc], XmNmaxLength, (int) maxLen), argc++;
  // turn off blinking cursor
  XtSetArg(argv[argc], XmNblinkRate, 0), argc++;

  rtr.mrep = XmCreateTextField(wparent, 
			       (char *) name, argv, argc);
}

TextField::operator CString(void) const
{
  char *mtext = XmTextFieldGetString(rtr.mrep);
  CString text;

  if (mtext) {
    text = mtext;
    XtFree(mtext);
  }
  return text;
}

const CString &
TextField::operator =(const CString &text)
{
  XmTextFieldSetString(rtr.mrep, (char *) text);
  return text;
};

CString 
TextField::operator +=(const CString &text)
{
  XmTextPosition endPos = XmTextFieldGetLastPosition(rtr.mrep);
  XmTextFieldInsert(rtr.mrep, endPos, (char *) text);
  return (CString) *this;
}

void 
TextField::showText(uint pos) const
{
  XmTextFieldShowPosition(rtr.mrep, (XmTextPosition) pos);
}

void     
TextField::lock   (void)
{
  XtVaSetValues(rtr.mrep,
		XmNeditable,              False,
		XmNcursorPositionVisible, False,
		NULL);
}

void     
TextField::unlock (void)
{
  XtVaSetValues(rtr.mrep,
		XmNeditable,              True,
		XmNcursorPositionVisible, True,
		NULL);
}
 
Boolean  
TextField::locked (void)
{
  Bool e;
  XtVaGetValues(rtr.mrep,
		XmNeditable, &e, NULL);
  return e;
}
