//############################################################
// TextField.h
// Kari Pulli
// 12/13/95
// A class for a Motif GUI library
//############################################################

#ifndef _TEXTFIELD_H_
#define _TEXTFIELD_H_

#include "GraphicalObject.h"
#include "CString.h"

class TextField : public GraphicalObject {
public:
  
  static const uint DefaultWidth;
    // def. # of chars to display
  static const uint Unlimited;
    // def. # of chars in the field

  TextField(const CString         &name,
	    const GraphicalObject *parent,
	    uint                   width  = DefaultWidth,
	    uint                   maxLen = Unlimited);
  ~TextField(void) {}

  operator CString(void) const;
    // get the current text of the field

  const CString &operator =(const CString &text);
    // replace current text

  CString operator +=(const CString &text);
    // append to current text

  void showText(uint pos) const;
    // show text starting at specified char pos

  void     lock   (void);
  void     unlock (void);
  Boolean  locked (void);
    // manipulate the edit status 
};

#endif
