//############################################################
// Trackball.h
// Kari Pulli
// 10/22/95
//############################################################

#include <GL/gl.h>
#include <GL/glu.h>

#include "Pnt3.h"

class Trackball {
private:
  float W; // window width
  float H; // window height
  float lastQuat[4], currQuat[4];
  int beginx;
  int beginy;
  int spinning;
  int panning;
  int zooming;
  int rotating;
  Pnt3 c,o,u,v,z,trans;
  float d;
  float znear, zfar, field_of_view, radius;

  void setPerspXform(void);

public:
  Trackball(void);
  void setSize(int w, int h);
  void setup(float c[3], float o[3], float up[3],
	     float r, float fov=45.0);
  void pressButton(int button, int up, int x, int y);
  void move(int x, int y);
  void spin(void);
  void getXform(float m[4][4], float t[3]);
  void applyXform(void);
  int  isSpinning(void)          { return spinning; }
  Pnt3 dir(void);
};



