
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>

#include <iostream.h>
#include "MainWindow.h"
#include "PulldownMenu.h"
#include "OptionMenu.h"
#include "TextButton.h"
#include "CascadeButton.h"
#include "MenuBar.h"
#include "Context.h"
#include "PixelMap.h"
#include "ControlPanel.h"
#include "PictureButton.h"
#include "PromptDialog.h"
#include "FileDialog.h"
#include "ErrorDialog.h"
#include "InfoDialog.h"
#include "WarningDialog.h"
#include "RadioBox.h"
#include "CustomDialog.h"
#include "Scale.h"
#include "Frame.h"
#include "GLDrawingArea.h"

#include "Trackball.h"

#define SHOW(x) cout << #x " = " << x << endl

int one = 1;


class OGLtest : public GLDrawingArea {
  Trackball TB;
  int xsize, ysize;
public:
  OGLtest(const CString         &name,
	  const GraphicalObject *parent = NULL,
	  int                    useAlpha = 0,
	  int                    useAcc = 0)
    : GLDrawingArea(name, parent, useAlpha, useAcc) { }

  void ginit(GLwDrawingAreaCallbackStruct *call_data)
    {
      glEnable(GL_DEPTH_TEST); // enable depth buffering
      glDepthFunc(GL_LESS);    // pedantic, GL_LESS is the default
      glClearDepth(1.0);       // pedantic, 1.0 is the default
      // frame buffer clears should be to black
      glClearColor(0.0, 0.0, 0.0, 0.0);
      // set up projection transform
      TB.setup(Pnt3(0,0,6), // camera
	       Pnt3(0,0,0), // object
	       Pnt3(0,1,0), // up
	       1.75);        // object radius
      resize(call_data);
    }
  void resize(GLwDrawingAreaCallbackStruct *call_data)
    {
      xsize = call_data->width;
      ysize = call_data->height;
      TB.setSize(xsize, ysize);
    }
  void expose(GLwDrawingAreaCallbackStruct *)
    {
      static GLboolean   displayListInited = GL_FALSE;

      TB.applyXform();

      if (displayListInited) {
	/* if display list already exists, just execute it */
	glCallList(1);
      } else {
	// otherwise compile and execute to create the display list
	glNewList(1, GL_COMPILE_AND_EXECUTE);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	/* front face */
	glBegin(GL_QUADS);
	glColor3f(0.0, 0.7, 0.1);	/* green */
	glVertex3f(-1.0, 1.0, 1.0);
	glVertex3f(1.0, 1.0, 1.0);
	glVertex3f(1.0, -1.0, 1.0);
	glVertex3f(-1.0, -1.0, 1.0);
	/* back face */
	glColor3f(0.9, 1.0, 0.0);	/* yellow */
	glVertex3f(-1.0, 1.0, -1.0);
	glVertex3f(1.0, 1.0, -1.0);
	glVertex3f(1.0, -1.0, -1.0);
	glVertex3f(-1.0, -1.0, -1.0);
	/* top side face */
	glColor3f(0.2, 0.2, 1.0);	/* blue */
	glVertex3f(-1.0, 1.0, 1.0);
	glVertex3f(1.0, 1.0, 1.0);
	glVertex3f(1.0, 1.0, -1.0);
	glVertex3f(-1.0, 1.0, -1.0);
	/* bottom side face */
	glColor3f(0.7, 0.0, 0.1);	/* red */
	glVertex3f(-1.0, -1.0, 1.0);
	glVertex3f(1.0, -1.0, 1.0);
	glVertex3f(1.0, -1.0, -1.0);
	glVertex3f(-1.0, -1.0, -1.0);
	glEnd();
	glEndList();
	displayListInited = GL_TRUE;
      }
    }
  void input(GLwDrawingAreaCallbackStruct *call_data)
    {
      int x,y;
      switch (call_data->event->type) {
      case ButtonPress:
	x = call_data->event->xbutton.x;
	y = call_data->event->xbutton.y;
	TB.pressButton(call_data->event->xbutton.button, 0, x, y);
	break;
      case ButtonRelease:
	x = call_data->event->xbutton.x;
	y = call_data->event->xbutton.y;
	TB.pressButton(call_data->event->xbutton.button, 1, x, y);
	break;
      case MotionNotify: 
	x = call_data->event->xbutton.x;
	y = call_data->event->xbutton.y;
	TB.move(x,y);
	break;
      }
      redraw();
    }
};  


void
myCB(GraphicalObject &parent, GraphicalObject::CallbackType , void *)
{
  static FileDialog dialog("File Dialog", &parent);
  dialog.setFilter("*.C");
  dialog.pose();

  if (!dialog.wasCancelled())
    cout << "Chose file " << (CString) dialog << endl;
}

void
pbCB(GraphicalObject &go, GraphicalObject::CallbackType , void *)
{
  static PromptDialog dialog("pict button dialog",
			     &go,
			     "Enter some text:");
  dialog.pose();

  if (!dialog.wasCancelled())
    cout << (CString) dialog << endl;

  cout << "Pressed" << endl;
}

void
inCB(GraphicalObject &go, GraphicalObject::CallbackType , void *)
{
  static InfoDialog dialog("Infodlg",
			   &go,
			   "Informational string");
  dialog.pose();
}

void
waCB(GraphicalObject &go, GraphicalObject::CallbackType , void *)
{
  static WarningDialog dialog("Warningdlg",
			      &go,
			      "Warning string");
  dialog.pose();
}

void
erCB(GraphicalObject &go, GraphicalObject::CallbackType , void *)
{
  static ErrorDialog dialog("Errordlg",
		       &go,
		       "Error message");
  dialog.pose();
}

void
oglCB(GraphicalObject &parent, GraphicalObject::CallbackType, void *)
{
  static CustomDialog dlg("OGL Dialog", &parent);
  static Form         frm("dlgForm", &dlg);
  static OGLtest      glda("glda", &frm);

  glda.setDimensions(300,300);
  glda.manage();
  frm.attachForm(glda, Form::TOP);
  frm.attachForm(glda, Form::LEFT);
  frm.attachForm(glda, Form::RIGHT);
  frm.attachForm(glda, Form::BOTTOM);
  dlg.customize(frm,0,0);
  dlg.pose(Dialog::NO_WAIT);
}

void
changeTextCB(GraphicalObject &go, GraphicalObject::CallbackType, void *)
{
  static int toggle = 0;
  toggle ^= 1;
  if (toggle)
    ((TextButton *)&go)->setLabel("new label");
  else
    ((TextButton *)&go)->setLabel("old label");
}

void
customDlgCB(GraphicalObject &go, GraphicalObject::CallbackType , void *)
{
  static char *names[] = {
    "highways", "railroads", "lakes",
    "rivers", "gullies", "side streets",
  };
  static CustomDialog dlg("featureDisplayDialog", &go);
  static Form         frm("dlgForm", &dlg);
  static RadioBox     box("changeDisplayBox",
			  &frm,
			  RadioBox::MANY,
			  2);
  static Scale        scl("scale", &frm);
  static int first = 1;
  int i;
  if (first) {
    first = 0;
    for (i=0; i<6; i++)
      box.addToggle(names[i]);
    scl.setBounds(10);
    scl.setLabel("Number of lines");
    scl = 5.0;
    frm.attachForm(box, Form::LEFT);
    frm.attachForm(box, Form::RIGHT);
    frm.attachForm(scl, Form::LEFT);
    frm.attachForm(scl, Form::RIGHT);
    frm.attachForm(box, Form::TOP);
    frm.attachForm(scl, Form::BOTTOM);
    frm.attachObjects(box, scl, Form::BOTTOM);
    box.manage(), scl.manage();
    dlg.customize(frm);
  }
  dlg.pose();

  if (!dlg.wasCancelled()) {
    for (i=0; i<6; i++)
      if (box.isSet(i))
	cout << names[i] << " is set (" << i << ")" << endl;
    cout << "Scale value is " << (double) scl << endl;
  }
}

void
main(int argc, char **argv)
{
  GraphicalEnv::setEnvironment("pmDemo", argc, argv);
  
  PixelMap *pm = new PixelMap;
  if (!pm->read("pixmap.pm")) {
    cout << "exiting..." << endl;
    exit(1);
  }

  MainWindow    mainWindow  ("mainWindow");
  ControlPanel  panel       ("panel",        mainWindow);
  PictureButton pb1         ("pb1",          panel, pm);
  ControlPanel  bpanel      ("bpanel",       mainWindow,
			     ControlPanel::HORIZONTAL);
  TextButton    tb0         ("Exit",        &bpanel);
  MenuBar       menuBar     ("menuBar",      mainWindow);
  PulldownMenu  fileMenu    ("fileMenu",     menuBar),
                helpMenu    ("helpMenu",     menuBar);
  CascadeButton fileButton  ("File",         fileMenu, menuBar),
                helpButton  ("Help",         helpMenu, menuBar);
  TextButton    tb1         ("New File",    &fileMenu);
  fileMenu.addSeparator();
  TextButton    tb2         ("Change Path", &fileMenu),
                tb3         ("Contents",    &helpMenu),
                tb4         ("Info",        &helpMenu),
                tb5         ("Warning",     &helpMenu),
                tb6         ("Error",       &helpMenu);
  PulldownMenu  subMenu     ("subMenu",      fileMenu);
  CascadeButton cb1         ("More...",      subMenu, fileMenu);
  TextButton    sm1         ("More 1",      &subMenu);
  TextButton    sm2         ("More 2",      &subMenu);
  Frame         workSpace   ("workSpace",   &mainWindow);

  menuBar.setHelpButton(helpButton);
  mainWindow.set(workSpace, &menuBar, &panel, &bpanel);

  tb1.registerCallback(GraphicalObject::CB_ACTIVE, myCB);
  tb1.setAccelerator("Ctrl<Key>f", "Ctrl+F");
  tb3.registerCallback(GraphicalObject::CB_ACTIVE, customDlgCB);
  tb4.registerCallback(GraphicalObject::CB_ACTIVE, inCB);
  tb5.registerCallback(GraphicalObject::CB_ACTIVE, waCB);
  tb6.registerCallback(GraphicalObject::CB_ACTIVE, erCB);
  sm1.registerCallback(GraphicalObject::CB_ACTIVE, oglCB);
  sm2.registerCallback(GraphicalObject::CB_ACTIVE, changeTextCB);
  pb1.setDimensions(35,35);
  pb1.registerCallback(GraphicalObject::CB_ACTIVE, pbCB);
  workSpace.manage();
  cb1.manage();
  fileMenu.manage(), helpMenu.manage();
  menuBar.manage();
  panel.manage();
  bpanel.manage();
  mainWindow.manage();
  tb1.setColor("red");
  tb2.setColor("green");

  SoXt::init((Widget)mainWindow);
  SoXtExaminerViewer *viewer = new SoXtExaminerViewer((Widget)workSpace);
  viewer->show();

  mainWindow.realizeAll();

  GraphicalEnv::startApp();
}

