
#include <Inventor/Xt/SoXt.h>
#include <Inventor/Xt/viewers/SoXtExaminerViewer.h>
#include <Inventor/nodes/SoOrthographicCamera.h>
#include <Inventor/nodes/SoMaterial.h>
#include <Inventor/nodes/SoCallback.h>
#include <Inventor/nodes/SoShapeHints.h>
#include <GL/gl.h>

#include <iostream.h>
#include <fstream.h>
#include "MainWindow.h"
#include "Frame.h"
#include "PulldownMenu.h"
#include "TextButton.h"
#include "CascadeButton.h"
#include "MenuBar.h"
#include "Context.h"
#include "FileDialog.h"
#include "InfoDialog.h"
#include "CustomDialog.h"
#include "RadioBox.h"
#include "geometry.h"
#include "SimuRange.h"

SoXtExaminerViewer *viewer;
SoSeparator *root;
Geometry *g;

void
openCB(GraphicalObject &parent, GraphicalObject::CallbackType , 
       void *)
{
  static FileDialog dialog("Open File", &parent);

  dialog.pose(Dialog::NO_WAIT);

  while(!dialog.wasDismissed()) GraphicalEnv::processEvent();

  if (!dialog.wasCancelled()) {
    dialog.setCursor(GraphicalObject::WATCH);
    Geometry *_g = new Geometry;
    _g->readFile((char *)(CString) dialog);
    root->addChild(_g->getRoot());
    dialog.setCursor(GraphicalObject::DEFAULT);
    viewer->viewAll();
  }
  
  dialog.unmanage();
}

void
saveCB(GraphicalObject &parent, 
       GraphicalObject::CallbackType , 
       void *)
{
  static FileDialog dialog("Save File", &parent);
  dialog.pose();

  if (dialog.wasCancelled()) return;
  static CustomDialog dlg("Write Dialog", &parent);
  static RadioBox     box("changeDisplayBox",
			  &dlg,
			  RadioBox::ALWAYS_ONE);
  static char *names[] = { "INVENTOR", "UW", 0 };
  static int first = 1;
  int i;
  if (first) {
    first = 0;
    for (i=0; names[i]; i++)
      box.addToggle(names[i]);
    dlg.customize(box);
    box.changeToggle(0, TRUE);
  }
  DLG_START(dlg);
    for (i=0; names[i]; i++)
      if (box.isSet(i)) g->writeFile((CString) dialog, i);
  DLG_END(dlg);
}

void
exitCB(GraphicalObject &, GraphicalObject::CallbackType , void *)
{
  exit(1);
}

static int shoot = 0;

static char zname[80];

static void 
accessZGL(void *, SoAction *)
{
  if (shoot) {
    shoot = 0;
    SimuRange sr(640,480);
    sr.shoot((SoXtViewer *)viewer, zname);
  }
}

void
getZCB(GraphicalObject &parent, 
       GraphicalObject::CallbackType , void *)
{
  static FileDialog dialog("Save View", &parent);
  DLG_START(dialog);
    strcpy(zname, (char *)(CString) dialog);
  DLG_END(dialog);

  static int first = 1;
  shoot = 1;
  if (first) {
    SoCallback *glCB = new SoCallback;
    glCB->setCallback(accessZGL);
    root->addChild(glCB);
    first = 0;
  }
  root->touch();
}


void 
parse_args(int argc, char **argv)
{
  for (int i=0; i<argc; i++) {
    if (argv[i][0] == '-') {
      if (argv[i][1] == 'i')
	g->ignore_colors();
    } else {
      // read a file
      g->readFile(argv[i]);
    }
  }
}

void
main(int argc, char **argv)
{
  GraphicalEnv::setEnvironment(argv[0], argc, argv);

  MainWindow    mainWindow  ("mainWindow");
  MenuBar       menuBar     ("menuBar",      mainWindow);
  PulldownMenu  fileMenu    ("fileMenu",     menuBar),
                otherMenu   ("otherMenu",    menuBar),
                helpMenu    ("helpMenu",     menuBar);
  CascadeButton fileButton  ("File",         fileMenu, menuBar);
  TextButton    tbO         ("Open",        &fileMenu);
  TextButton    tbS         ("Save",        &fileMenu);
  fileMenu.addSeparator();
  TextButton    tb2         ("Exit",        &fileMenu);
  CascadeButton otherButton ("Other",        otherMenu, menuBar);
  TextButton    tbZ         ("GetZvals",    &otherMenu);
  Frame         workSpace   ("workSpace",   &mainWindow);

  mainWindow.set(workSpace, &menuBar);
  workSpace.setDimensions(650, 490); 
  // leaves 640x480 for viewport when decoration is off

  tbO.registerCallback(GraphicalObject::CB_ACTIVE, openCB);
  tbO.setAccelerator("Ctrl<Key>o", "Ctrl+O");
  tbS.registerCallback(GraphicalObject::CB_ACTIVE, saveCB);
  tbS.setAccelerator("Ctrl<Key>s", "Ctrl+S");
  tb2.registerCallback(GraphicalObject::CB_ACTIVE, exitCB);
  tb2.setAccelerator("Ctrl<Key>x", "Ctrl+X");
  tbZ.registerCallback(GraphicalObject::CB_ACTIVE, getZCB);
  workSpace.manage();
  fileMenu.manage();
  menuBar.manage();
  mainWindow.manage();

  SoXt::init((Widget)mainWindow);
  viewer = new SoXtExaminerViewer((Widget)workSpace);
  viewer->show();

  mainWindow.realizeAll();

  root = new SoSeparator;
  g = new Geometry;

  parse_args(argc-1, &argv[1]);

  viewer->setCameraType(SoOrthographicCamera::getClassTypeId());
//  viewer->setBackgroundColor(SbColor(.5,.5,1.));

  // get 2 sided rendering and ccw ordering of vertices
  SoShapeHints *shapehint = new SoShapeHints;
  root->addChild(shapehint);
  shapehint->vertexOrdering = SoShapeHints::COUNTERCLOCKWISE;

  root->addChild(g->getRoot());
  SoMaterial *mat = new SoMaterial;
  mat->diffuseColor.setValue(SbColor(1., 1., 0.));
  root->addChild(mat);

  viewer->setSceneGraph(root);
  viewer->viewAll();

  GraphicalEnv::startApp();
}





