package csci4534.scheduler;

/**
 * A scheduling decision.
 *
 * @author Toli Lerios
 **/

public class Decision
{

    // INSTANCE DATA.

    private Process mProcess;
    private int mTimeout;


    // CONSTRUCTORS.

    /**
     * Creates a new scheduling decision.
     *
     * @param process The process that will take over the CPU.
     * @param timeout The maximum time interval for which the CPU is
     * reserved for the process; the process may actually end before
     * this time interval elapses.
     **/

    public Decision(Process process,
                    int timeout)
    {
        mProcess=process;
        mTimeout=Math.min(timeout,mProcess.getRemainingTime());
    }

    /**
     * Creates a new scheduling decision. The timeout is set to the
     * remaining CPU time of the process; that is, the process can use
     * the CPU until it has completed its execution.
     *
     * @param process The process that will take over the CPU.
     **/

    public Decision(Process process)
    {
        mProcess=process;
        mTimeout=mProcess.getRemainingTime();
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the process that will take over the CPU.
     *
     * @return The process.
     **/

    public Process getProcess()
    {
        return mProcess;
    }

    /**
     * Returns the time interval for which the CPU is reserved for the
     * process.
     *
     * @return The time interval.
     **/

    public int getTimeout()
    {
        return mTimeout;
    }
}
