package csci4534.scheduler;

/**
 * A process.
 *
 * @author Toli Lerios
 **/

public class Process
{

    // INSTANCE DATA.

    private String mName;
    private int mPriority;
    private int mArrivalTime;
    private int mRemainingTime;
    private int mWaitingTime;
    private int mTransitionTime;


    // CONSTRUCTORS.

    /**
     * Creates a new process.
     *
     * @param name The process name.
     * @param priority The process priority.
     * @param arrivalTime The arrival time of the process.
     * @param remainingTime The remaining time the process needs to
     * spend on the CPU.
     **/

    public Process(String name,
                   int priority,
                   int arrivalTime,
                   int remainingTime)
    {
        mName=name;
        mPriority=priority;
        mArrivalTime=arrivalTime;
        mRemainingTime=remainingTime;
        mWaitingTime=0;
        mTransitionTime=mArrivalTime;
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the process name. It is constant throughout the process
     * lifetime.
     *
     * @return The name.
     **/

    public String getName()
    {
        return mName;
    }

    /**
     * Returns the process priority. It is constant throughout the
     * process lifetime.
     *
     * @return The priority.
     **/

    public int getPriority()
    {
        return mPriority;
    }

    /**
     * Returns the arrival time of the process. It is constant
     * throughout the process lifetime.
     *
     * @return The time.
     **/

    public int getArrivalTime()
    {
        return mArrivalTime;
    }

    /**
     * Returns the remaining time the process needs to spend on the
     * CPU.
     *
     * @return The time.
     **/

    public int getRemainingTime()
    {
        return mRemainingTime;
    }

    /**
     * Returns the time the process has so far spent waiting for the
     * CPU.
     *
     * @return The time.
     **/

    public int getWaitingTime()
    {
        return mWaitingTime;
    }

    /**
     * Notifies the process that it has started running at the given
     * time.
     *
     * @param time The time.
     **/

    public void startRunning(int time)
    {
        mWaitingTime+=(time-mTransitionTime);
        mTransitionTime=time;
    }

    /**
     * Notifies the process that it has stopped running at the given
     * time.
     *
     * @param time The time.
     **/

    public void stopRunning(int time)
    {
        mRemainingTime-=(time-mTransitionTime);
        mTransitionTime=time;
    }


    // Object.

    public String toString()
    {
        StringBuffer buffer=new StringBuffer();
        buffer.append('(');
        buffer.append(getName());
        buffer.append(',');
        buffer.append(getPriority());
        buffer.append(',');
        buffer.append(getArrivalTime());
        buffer.append(',');
        buffer.append(getRemainingTime());
        buffer.append(',');
        buffer.append(getWaitingTime());
        buffer.append(')');
        return buffer.toString();
    }
}
