package csci4534.scheduler;

/**
 * A scheduler. The {@link MainSimulator} invokes the scheduler to
 * choose a process to run on the simulated CPU. The simulator always
 * calls into the same class instance which implements this interface;
 * therefore, that instance can keep track of information (state) that
 * will be available across different calls.
 *
 * @author Toli Lerios
 **/

public interface Scheduler
{

    // PUBLIC INTERFACE.

    /**
     * Makes a scheduling decision. 
     *
     * @param processes The processes that are waiting for the
     * CPU. This non-empty array may change only as follows between
     * successive calls:
     *
     * <UL>
     *
     * <LI> If the process that was just using the CPU ended, it will
     * be removed from the set.
     *
     * <LI> New processes may be added anywhere in the array. Those
     * processes are the ones that arrived while the most recently
     * running process was using the CPU.
     *
     * </UL>
     *
     * All processes which are common between the previous invokation
     * and this one will have the same order relative to each other.
     *
     * @return The decision. It consists of the process that will take
     * over the CPU, and (optionally) the time interval for which the
     * CPU is reserved for the process. The process must be one of the
     * array elements. If a time interval is not specified, the
     * process keeps the CPU until it completes its execution.
     **/

    public Decision choose(Process[] processes);
}
