package csci4534.calculator;

import java.io.Serializable;

/**
 * Maps an integer onto another integer based on the result of some
 * arbitrary computation. Both integers are represented using
 * <CODE>long</CODE> to reduce the probability of overflow.
 *
 * <P>
 *
 * Instances of this class are serializable, which enables a client to
 * pass a custom calculator to a compute server via their connecting
 * socket.
 *
 * @author Toli Lerios
 **/

public interface Calculator
    extends Serializable
{

    // PUBLIC INTERFACE.

    /**
     * Maps a given integer onto another integer. The only constraint
     * is that every time the method is called with the same input,
     * then all these calls should produce the same output.
     *
     * @param input The integer to be mapped.
     *
     * @return The result of the mapping.
     *
     * @throws Exception Thrown iff an error occurs.
     **/

    public long compute(long input)
        throws Exception;
}
