package csci4534.calculator;

/**
 * A command-line calculator.
 *
 * @author Toli Lerios
 **/

public class MainCalculator
{

    // PUBLIC INTERFACE.

    /**
     * Main program.
     *
     * @param args The command-line arguments: execute without
     * arguments for usage instructions.
     *
     * @throws Exception Thrown iff an error occurs.
     **/

    public static void main(String[] args)
        throws Exception
    {

        // Error-checking.

        if (args.length!=2) {
            System.err.println("Usage: <calculator> <input>");
            return;
        }

        // Instantiate calculator implementation.

        Calculator calculator=(Calculator)Class.forName(args[0]).newInstance();
        System.err.println("Calculator: "+calculator.getClass().getName());

        // Parse calculator input.

        long input=Long.parseLong(args[1]);

        // Compute.

        System.out.println
            ("Result on input "+input+" is "+calculator.compute(input));
    }
}
