package csci4534.client;

import csci4534.calculator.Calculator;
import csci4534.server.Server;

/**
 * A client to a {@link Server}.
 *
 * <P>
 *
 * Instances of this class are first constructed, then initialized,
 * then asked to perform zero or more calculations, and finally they
 * are shut down. To perform calculations, the user of this class
 * calls the inherited {@link #compute(long)} method: the client sends
 * the input integer to the server, as a serialized long, and waits
 * for the computation result. This arrives whenever the server
 * completes the computation, and is also in the form of a serialized
 * long.
 *
 * @author Toli Lerios
 **/

public interface Client
    extends Calculator
{

    // PUBLIC INTERFACE.

    /**
     * Initializes the client. This method is always called once for
     * each instance, and before any other method of the same instance
     * is called. The client should establish a connection to the
     * server, and send the given calculator as a serialized object.
     *
     * @param host The name of the host on which the compute server is
     * running.
     * @param port The port on which the compute server is listening.
     * @param calculator The calculator which will perform all
     * computations on the server.
     *
     * @throws Exception Thrown iff an error occurs.
     **/

    public void initialize(String host,
                           int port,
                           Calculator calculator)
        throws Exception;

    /**
     * Shuts down the client. This method is only called if {@link
     * #initialize(String,int,Calculator)} succeeded, and after all
     * computations via {@link #compute(long)} are completed. No other
     * methods will be called after this method.
     *
     * @throws Exception Thrown iff an error occurs.
     **/

    public void close()
        throws Exception;
}
