package csci4534.client;

import csci4534.calculator.Calculator;

/**
 * A command-line client to a compute server.
 *
 * @author Toli Lerios
 **/

public class MainClient
{

    // PUBLIC INTERFACE.

    /**
     * Main program.
     *
     * @param args The command-line arguments: execute without
     * arguments for usage instructions.
     *
     * @throws Exception Thrown iff an error occurs.
     **/

    public static void main(String[] args)
        throws Exception
    {

        // Error-checking.

        if (args.length<2) {
            System.err.println
                ("Usage: <host>:<port> <calculator> <number>*");
            return;
        }

        // Parse fixed command-line arguments.

        int separator=args[0].indexOf(':');
        String host=args[0].substring(0,separator);
        System.err.println("Host: "+host);
        int port=Integer.parseInt(args[0].substring(separator+1));
        System.err.println("Port: "+port);
        Calculator calculator=(Calculator)Class.forName(args[1]).newInstance();
        System.err.println("Calculator: "+calculator.getClass().getName());

        // Initialize client.

        Client client=new SocketClient();
        client.initialize(host,port,calculator);
        try {

            // Perform computation for each remaining command-line
            // argument.

            for (int i=2;i<args.length;i++) {
                long input=Long.parseLong(args[i]);
                System.out.println
                    ("Result on input "+input+" is "+client.compute(input));
            }
        } finally {

            // Cleanup.

            client.close();
        }
    }
}
