package csci4534.server;

/**
 * A command-line compute server.
 *
 * @author Toli Lerios
 **/

public class MainServer
{

    // PUBLIC INTERFACE.

    /**
     * Main program.
     *
     * @param args The command-line arguments: execute without
     * arguments for usage instructions.
     *
     * @throws Exception Thrown iff an error occurs.
     **/

    public static void main(String[] args)
        throws Exception
    {

        // Error-checking.

        if (args.length<1) {
            System.err.println("Usage: <port>");
            return;
        }

        // Parse command-line arguments.

        int port=Integer.parseInt(args[0]);
        System.err.println("Port: "+port);

        // Start server.

        (new SocketServer()).serve(port);
    }
}
