package csci4534.server;

import csci4534.client.Client;

/**
 * A compute server, which typically serves {@link Client} instances.
 *
 * @author Toli Lerios
 **/

public interface Server
{

    // PUBLIC INTERFACE.

    /**
     * Starts the server. This entails setting up a server socket and
     * waiting for incoming compute requests. What such a request
     * arrives, the server first retrieves the serialized calculator
     * from the request's input stream. If it's an instance of {@link
     * EndCalculator}, the server shuts down and this method
     * returns.
     *
     * <P>
     *
     * Otherwise, the server starts a separate thread to handle all
     * further processing related to this request, while the main
     * thread goes back to waiting for more requests. In the meantime,
     * the spawned thread waits for serialized calculator inputs to
     * arrive on the input stream, performs the calculation, and
     * places the serializede result on the output stream. Within each
     * thread, the results of prior calculations are cached so that if
     * the same request supplies the same input more than once, then
     * the result is retrieved from the cached instead of being
     * recomputed.
     *
     * @param port The port on which the server is listening.
     *
     * @throws Exception Thrown iff an error occurs.
     **/

    public void serve(int port)
        throws Exception;
}
