package csci4534.controller;

// ADD CODE HERE IF APPROPRIATE.

/**
 * An address translator. It transforms a logical address issued by a
 * process into a physical address, based on the controller's
 * configuration. It also retains key data structures traversed during
 * the translation process.
 *
 * <P>
 *
 * The mapping of logical to physical addresses follows closely the
 * two-step approach of the Intel 80386 architecture under OS/2:
 *
 * <OL>
 *
 * <LI> <STRONG>Segmentation</STRONG>. A logical address has two
 * parts: a segment number <EM>s</EM> followed by a segment
 * offset. The segment number (a.k.a. segment selector) is used to
 * look up the appropriate segment's base and limit. The limit is
 * compared to the segment offset, and if the offset is less we
 * proceed; otherwise, we report a failure. We then add the segment
 * base to the offset to obtain the linear address.
 *
 * <P>
 *
 * <LI> <STRONG>Paging</STRONG>. A linear address is split into three
 * parts: <EM>p<SUB>1</SUB></EM>, <EM>p<SUB>2</SUB></EM>, and
 * <EM>d</EM>. <EM>p<SUB>1</SUB></EM> is an index into the page
 * directory, from which we retrieve the appropriate page
 * table. <EM>p<SUB>2</SUB></EM> is an index into that page table,
 * from which we retrieve the frame number. <EM>d</EM> is the frame
 * offset. We then glue together frame number and <EM>d</EM> to obtain
 * the physical address.
 *
 * </OL>
 *
 * The width (number of bits) of the logical and linear address parts
 * are specified inside an instance of {@link ControllerConfiguration}
 * provided to the constructor.
 *
 * <P>
 *
 * This class is designed to mirror closely the hardware, microcode,
 * or heavily optimized kernel code implementation of the same
 * calculations. <STRONG>This class does not perform any divisions or
 * multiplications <EM>on addresses</EM> during its execution. All
 * arithmetic address computations, besides addition and comparisons,
 * are performed via the methods of {@link
 * ControllerConfiguration}.</STRONG> Our only simplification is that
 * we assume all computation inputs and results can fit in the
 * non-negative range of the <CODE>int</CODE> datatype. Note that
 * table lookups are not explicit arithmetic computations, so they are
 * allowed by the above constraint.
 *
 * @author Toli Lerios
 **/

public class AddressTranslation
{

    // ADD CODE HERE IF APPROPRIATE.


    // CONSTRUCTORS.

    /**
     * Creates a new address translator for the given logical address
     * issued by the given process.
     *
     * @param configuration The controller's configuration.
     * @param process The process.
     * @param logicalAddress The logical address.
     *
     * @throws ControllerException Thrown iff there is a controller
     * failure, such as receiving a logical address whose offset is
     * at or beyond a segment's limit.
     **/

    public AddressTranslation(ControllerConfiguration configuration,
                              Process process,
                              int logicalAddress)
        throws ControllerException
    {

        // ADD CODE HERE IF APPROPRIATE.

    }


    // PUBLIC INTERFACE.

    /**
     * Returns the segment descriptor.
     *
     * @return The descriptor.
     **/

    public SegmentDescriptor getSegmentDescriptor()
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return null;
    }

    /**
     * Returns the page table entry.
     *
     * @return The entry.
     **/

    public PageTableEntry getPageTableEntry()
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return null;
    }

    /**
     * Returns the physical address.
     *
     * @return The address.
     **/

    public int getPhysicalAddress()
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }
}
