package csci4534.controller;

/**
 * A byte-addressable disk block. Its capacity is always equal to that
 * of a frame. Each byte is identifiable via its <EM>offset</EM>,
 * which is in the range [0,{@link #getCapacity()}-1].
 * 
 * @author Toli Lerios
 **/

public class Block
{

    // INSTANCE DATA.

    private byte[] mData;


    // CONSTRUCTORS.

    /**
     * Creates a disk block.
     *
     * @param capacity The block capacity, in bytes. It should be 
     * equal to the frame size.
     **/

    public Block(int capacity)
    {
        mData=new byte[capacity];
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the block capacity.
     *
     * @return The block capacity, in bytes.
     **/

    public int getCapacity()
    {
        return mData.length;
    }

    /**
     * Returns the block contents at the given offset.
     *
     * @param offset The offset.
     *
     * @return The contents.
     **/

    public byte read(int offset)
    {
        return mData[offset];
    }

    /**
     * Sets the block contents at the given offset to the given value.
     *
     * @param offset The offset.
     * @param value The value.
     **/

    public void write(int offset,
                      byte value)
    {
        mData[offset]=value;
    }


    // Object.

    public String toString()
    {
        StringBuffer buffer=new StringBuffer();
        buffer.append('(');
        for (int i=0;i<getCapacity();i++) {
            if (i>0) {
                buffer.append(',');
            }
            buffer.append(read(i));
        }
        buffer.append(')');
        return buffer.toString();
    }
}
