package csci4534.controller;

// ADD CODE HERE IF APPROPRIATE.

/**
 * The controller's configuration. Given the number of bits for each
 * portion of a logical and a linear address, it handles the majority
 * of memory management computations.
 *
 * <P>
 *
 * This class is designed to mirror closely the hardware, microcode,
 * or heavily optimized kernel code implementation of the same
 * calculations. <STRONG>This class does not perform any divisions or
 * multiplications on its data during its execution. All computations,
 * besides addition, are performed via the static methods of {@link
 * Utilities}.</STRONG> Our only simplification is that we assume all
 * computation inputs and results can fit in the non-negative range of
 * the <CODE>int</CODE> datatype.
 *
 * @author Toli Lerios
 **/

public class ControllerConfiguration
{

    // ADD CODE HERE IF APPROPRIATE.


    // CONSTRUCTORS.

    /**
     * Creates a new controller configuration.
     *
     * @param sBits The number of bits of the <EM>s</EM> (segment
     * number/selector) portion of a logical address.
     * @param offsetBits The number of bits of the segment offset
     * portion of a logical address.
     * @param p1Bits The number of bits of the <EM>p<SUB>1</SUB></EM>
     * (page directory index) portion of a linear address.
     * @param p2Bits The number of bits of the <EM>p<SUB>2</SUB></EM>
     * (page table index) portion of a linear address.
     * @param dBits The number of bits of the <EM>d</EM> (frame
     * offset) portion of a linear address.
     **/

    public ControllerConfiguration(int sBits,
                                   int offsetBits,
                                   int p1Bits,
                                   int p2Bits,
                                   int dBits)
    {

        // ADD CODE HERE IF APPROPRIATE.

    }


    // PUBLIC INTERFACE.

    /**
     * Returns the frame (or page, or disk block) size, in bytes.
     *
     * @return The size.
     **/

    public int getFrameSize()
	{

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
	}

    /**
     * Returns the maximum length of a segment, in bytes.
     *
     * @return The length.
     **/

    public int getMaxSegmentLength()
	{

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
	}

    /**
     * Returns the segment descriptor table capacity.
     *
     * @return The table capacity, in terms of the number of entries
     * it can retain.
     **/

    public int getDescriptorTableCapacity()
	{

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
	}

    /**
     * Returns the page directory capacity.
     *
     * @return The directory capacity, in terms of the number of
     * entries it can retain.
     **/

    public int getPageDirectoryCapacity()
	{

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
	}

    /**
     * Returns the page table capacity.
     *
     * @return The table capacity, in terms of the number of entries
     * it can retain.
     **/

    public int getPageTableCapacity()
	{

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
	}

    /**
     * Returns the <EM>s</EM> (segment number) portion of the given
     * logical address.
     *
     * @param logicalAddress The logical address.
     *
     * @return <EM>s</EM>.
     **/
    
    public int getS(int logicalAddress)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }

    /**
     * Returns the segment offset portion of the given logical
     * address.
     *
     * @param logicalAddress The logical address.
     *
     * @return The offset.
     **/
    
    public int getOffset(int logicalAddress)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }

    /**
     * Returns the <EM>p<SUB>1</SUB></EM> (page directory index)
     * portion of a linear address.
     *
     * @param linearAddress The linear address.
     *
     * @return <EM>p<SUB>1</SUB></EM>.
     **/
    
    public int getP1(int linearAddress)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }

    /**
     * Returns the <EM>p<SUB>2</SUB></EM> (page table index)
     * portion of a linear address.
     *
     * @param linearAddress The linear address.
     *
     * @return <EM>p<SUB>2</SUB></EM>.
     **/
    
    public int getP2(int linearAddress)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }

    /**
     * Returns the <EM>d</EM> (frame offset) portion of a linear
     * address.
     *
     * @param linearAddress The linear address.
     *
     * @return <EM>d</EM>.
     **/
    
    public int getD(int linearAddress)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }

    /**
     * Returns the number of frames (or pages, or disk blocks) needed
     * to store the given number of bytes.
     *
     * @param byteCount The number of bytes. It is not necessarily an
     * integral multiple of the frame size.
     *
     * @return The count.
     **/

    public int getFrameCount(int byteCount)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }

    /**
     * Returns the logical address given its parts.
     *
     * @param s The <EM>s</EM> (segment number) portion.
     * @param offset The segment offset portion.
     *
     * @return The logical address.
     **/

    public int getLogicalAddress(int s,
                                 int offset)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }

    /**
     * Returns the linear address given its parts.
     *
     * @param p1 The <EM>p<SUB>1</SUB></EM> (page directory index)
     * portion.
     * @param p2 The <EM>p<SUB>2</SUB></EM> (page table index)
     * portion.
     * @param d The <EM>d</EM> (frame offset) portion.
     *
     * @return The linear address.
     **/

    public int getLinearAddress(int p1,
                                int p2,
                                int d)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }

    /**
     * Returns the physical address given the frame number and
     * <EM>d</EM> (frame offset).
     *
     * @param frameNumber The frame number.
     * @param d The frame offset.
     *
     * @return The physical address.
     **/

    public int getPhysicalAddress(int frameNumber,
                                  int d)
    {

        // ADD CODE HERE IF APPROPRIATE.

        // REMOVE THE LINE BELOW.
        return 0;
    }
}
