package csci4534.controller;

/**
 * A Direct Memory Access (DMA) controller that transfers data between
 * disk and memory.
 * 
 * @author Toli Lerios
 **/

public class DMAController
{

    // PUBLIC INTERFACE.

    /**
     * Copies the contents of the given disk block into memory at the
     * given physical address. Because a disk block contains as many
     * bytes as a frame, the number of bytes transferred is equal to
     * the frame size.
     *
     * @param disk The disk.
     * @param index The block index.
     * @param memory The memory.
     * @param physicalAddress The physical address.
     **/

    public void toMemory(Disk disk,
                         int index,
                         Memory memory,
                         int physicalAddress)
    {
        System.out.print("[DR:"+index+"->"+physicalAddress+"]=");
        Block block=disk.getBlock(index);
        for (int i=0;i<block.getCapacity();i++) {
            memory.write(physicalAddress++,block.read(i));
        }
    }

    /**
     * Copies the contents of memory at the given physical address
     * into the given disk block. Because a disk block contains as
     * many bytes as a frame, the number of bytes transferred is equal
     * to the frame size.
     *
     * @param memory The memory.
     * @param physicalAddress The physical address.
     * @param disk The disk.
     * @param index The block index.
     **/

    public void toDisk(Memory memory,
                       int physicalAddress,
                       Disk disk,
                       int index)
    {
        System.out.print("[DW:"+physicalAddress+"->"+index+"]=");
        Block block=disk.getBlock(index);
        for (int i=0;i<block.getCapacity();i++) {
            block.write(i,memory.read(physicalAddress++));
        }
    }
}
