package csci4534.controller;

/**
 * A segment descriptor table. Each entry is a {@link
 * SegmentDescriptor}; it is identifiable via its <EM>index</EM>,
 * which is in the range [0,{@link #getCapacity()}-1].
 * 
 * @author Toli Lerios
 **/

public class DescriptorTable
{

    // INSTANCE DATA.

    private SegmentDescriptor[] mEntries;


    // CONSTRUCTORS.

    /**
     * Creates a segment descriptor table.
     *
     * @param capacity The number of entries the table can retain.
     **/

    public DescriptorTable(int capacity)
    {
        mEntries=new SegmentDescriptor[capacity];
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the table capacity.
     *
     * @return The table capacity, in terms of the number of entries
     * it can retain.
     **/

    public int getCapacity()
    {
        return mEntries.length;
    }

    /**
     * Returns the table entry at the given index.
     *
     * @param index The index.
     *
     * @return The entry.
     **/

    public SegmentDescriptor getEntry(int index)
    {
        return mEntries[index];
    }

    /**
     * Sets the table entry at the given index to the given value.
     *
     * @param index The index.
     * @param value The value.
     **/

    public void setEntry(int index,
                         SegmentDescriptor value)
    {
        mEntries[index]=value;
    }
}
