package csci4534.controller;

/**
 * A disk. Its capacity in bytes is always an exact multiple of the
 * frame size, because each disk block's capacity is always equal to
 * that of a frame; however, the number of disk blocks is
 * arbitrary. Each block is identifiable via its <EM>index</EM>, which
 * is in the range [0,{@link #getCapacity()}-1].
 * 
 * @author Toli Lerios
 **/

public class Disk
{

    // INSTANCE DATA.

    private Block[] mBlocks;


    // CONSTRUCTORS.

    /**
     * Creates a disk.
     *
     * @param capacity The disk capacity, in blocks.
     * @param blockCapacity The block capacity, in bytes. It should be
     * equal to the frame size.
     **/

    public Disk(int capacity,
                int blockCapacity)
    {
        mBlocks=new Block[capacity];
        for (int i=0;i<getCapacity();i++) {
            mBlocks[i]=new Block(blockCapacity);
        }
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the disk capacity.
     *
     * @return The disk capacity, in blocks.
     **/

    public int getCapacity()
    {
        return mBlocks.length;
    }

    /**
     * Returns the disk block at the given index.
     *
     * @param index The index.
     *
     * @return The block.
     **/

    public Block getBlock(int index)
    {
        return mBlocks[index];
    }


    // Object.

    public String toString()
    {
        StringBuffer buffer=new StringBuffer();
        buffer.append('[');
        for (int i=0;i<getCapacity();i++) {
            if (i>0) {
                buffer.append(';');
            }
            buffer.append(getBlock(i));
        }
        buffer.append(']');
        return buffer.toString();
    }
}
