package csci4534.controller;

/**
 * A byte-addressable memory. Its capacity is always an exact multiple
 * of the frame size. Each byte is identifiable via its <EM>physical
 * addresses</EM>, which is in the range [0,{@link #getCapacity()}-1].
 * 
 * @author Toli Lerios
 **/

public class Memory
{

    // INSTANCE DATA.

    private byte[] mData;


    // CONSTRUCTORS.

    /**
     * Creates a byte-addressable memory.
     *
     * @param capacity The memory capacity, in bytes. It should be an
     * exact multiple of the frame size.
     **/

    public Memory(int capacity)
    {
        mData=new byte[capacity];
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the memory capacity.
     *
     * @return The memory capacity, in bytes.
     **/

    public int getCapacity()
    {
        return mData.length;
    }

    /**
     * Returns the memory contents at the given physical address.
     *
     * @param physicalAddress The physical address.
     *
     * @return The contents.
     **/

    public byte read(int physicalAddress)
    {
        return mData[physicalAddress];
    }

    /**
     * Sets the memory contents at the given address to the given
     * value.
     *
     * @param physicalAddress The physical address.
     * @param value The value.
     **/

    public void write(int physicalAddress,
                      byte value)
    {
        mData[physicalAddress]=value;
    }


    // Object.

    public String toString()
    {
        StringBuffer buffer=new StringBuffer();
        buffer.append('[');
        for (int i=0;i<getCapacity();i++) {
            if (i>0) {
                buffer.append(',');
            }
            buffer.append(read(i));
        }
        buffer.append(']');
        return buffer.toString();
    }
}
