package csci4534.controller;

/**
 * A page directory. Each entry is a {@link PageDirectoryEntry}; it is
 * identifiable via its <EM>index</EM>, which is in the range
 * [0,{@link #getCapacity()}-1].
 * 
 * @author Toli Lerios
 **/

public class PageDirectory
{

    // INSTANCE DATA.

    private PageDirectoryEntry[] mEntries;


    // CONSTRUCTORS.

    /**
     * Creates a page directory.
     *
     * @param capacity The number of entries the directory can retain.
     **/

    public PageDirectory(int capacity)
    {
        mEntries=new PageDirectoryEntry[capacity];
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the directory capacity.
     *
     * @return The directory capacity, in terms of the number of
     * entries it can retain.
     **/

    public int getCapacity()
    {
        return mEntries.length;
    }

    /**
     * Returns the directory entry at the given index.
     *
     * @param index The index.
     *
     * @return The entry.
     **/

    public PageDirectoryEntry getEntry(int index)
    {
        return mEntries[index];
    }

    /**
     * Sets the directory entry at the given index to the given value.
     *
     * @param index The index.
     * @param value The value.
     **/

    public void setEntry(int index,
                         PageDirectoryEntry value)
    {
        mEntries[index]=value;
    }
}
