package csci4534.controller;

/**
 * A page directory entry. If the entry is valid, the remaining entry
 * data describe the entry's page table; if the entry is not valid,
 * the remaining entry data should not be used.
 * 
 * @author Toli Lerios
 **/

public class PageDirectoryEntry
{

    // INSTANCE DATA.

    private boolean mValid;
    private PageTable mTable;


    // CONSTRUCTORS.

    /**
     * Creates a new entry.
     *
     * @param valid True iff the entry is a valid one.
     * @param table The page table.
     **/

    public PageDirectoryEntry(boolean valid,
                              PageTable table)
    {
        setValid(valid);
        setTable(table);
    }


    // PUBLIC INTERFACE.

    /**
     * Checks whether the entry is a valid one.
     *
     * @return True iff it is.
     **/

    public boolean isValid()
    {
        return mValid;
    }

    /**
     * Sets whether the entry is a valid one.
     *
     * @param valid True iff it is.
     **/

    public void setValid(boolean valid)
    {
        mValid=valid;
    }

    /**
     * Returns the entry's page table.
     *
     * @return The page table.
     **/

    public PageTable getTable()
    {
        return mTable;
    }

    /**
     * Sets the entry's page table to the given table.
     *
     * @param table The table.
     **/

    public void setTable(PageTable table)
    {
        mTable=table;
    }
}
