package csci4534.controller;

/**
 * A page table. Each entry is a {@link PageTableEntry}; it is
 * identifiable via its <EM>index</EM>, which is in the range
 * [0,{@link #getCapacity()}-1].
 * 
 * @author Toli Lerios
 **/

public class PageTable
{

    // INSTANCE DATA.

    private PageTableEntry[] mEntries;


    // CONSTRUCTORS.

    /**
     * Creates a page table.
     *
     * @param capacity The number of entries the table can retain.
     **/

    public PageTable(int capacity)
    {
        mEntries=new PageTableEntry[capacity];
    }


    // PUBLIC INTERFACE.

    /**
     * Returns the table capacity.
     *
     * @return The table capacity, in terms of the number of entries
     * it can retain.
     **/

    public int getCapacity()
    {
        return mEntries.length;
    }

    /**
     * Returns the table entry at the given index.
     *
     * @param index The index.
     *
     * @return The entry.
     **/

    public PageTableEntry getEntry(int index)
    {
        return mEntries[index];
    }

    /**
     * Sets the table entry at the given index to the given value.
     *
     * @param index The index.
     * @param value The value.
     **/

    public void setEntry(int index,
                         PageTableEntry value)
    {
        mEntries[index]=value;
    }
}
